<?php

require_once 'XML/Serializer.php';
require_once 'XML/Unserializer.php';


class XMLArticle
{

    private $xml = '';
    public  $a;
    
    public function __construct($filename)
    {
        $this->load($filename);
        $this->unserialize();
    }
    
    public function load($filename)
    {
        $gzfile = gzopen($filename, 'r');
        if ($filename === false) {
            throw new Exception('XMLArticle::load() exception');
        }
        $this->xml = '';
        while (!gzeof($gzfile)) {
            $this->xml .= gzread($gzfile, 10000);
        }
        gzclose($gzfile);
    }


    public function unserialize()
    {
        $unserializer = new XML_Unserializer();
        
        $options = array(
            'forceEnum' => array('item'),
        );
        $unserializer->setOptions($options);
        
        $unserializer->unserialize($this->xml, false);
        $this->a = $unserializer->getUnserializedData();
    }


    public function getFiguresCount()
    {
        return $this->a['figures_count'];
    }
    
    public function getFigure($i)
    {
        return $this->a['figures']['item'][$i - 1];
    }
    
    public function getListingsCount()
    {
        return $this->a['listings_count'];
    }

    public function getListing($i)
    {
        return $this->a['listings']['item'][$i - 1];
    }
    
    public function getFramesCount()
    {
        return $this->a['frames_count'];
    }

    public function getFrame($i)
    {
        return $this->a['frames']['item'][$i - 1];
    }
    
    public function getTablesCount()
    {
        return $this->a['tables_count'];
    }

    public function getTable($i)
    {
        return $this->a['tables']['item'][$i - 1];
    }
    
    

    public function getExamplesCount()
    {
        return $this->a['examples_count'];
    }
    
    public function getExamples()
    {
        return $this->a['examples'];
    }
    
    public function getDownloadCount()
    {
        return $this->a['download_count'];
    }
    
    public function getDownload()
    {
        return $this->a['download'];
    }
    
    public function getAddressesCount()
    {
        return $this->a['addresses_count'];
    }
    
    public function getAddresses()
    {
        return $this->a['addresses'];
    }
    
    public function getArticle()
    {
        return $this->a['article'];
    }
    
    public function getTitle()
    {
        return $this->a['title'];
    }
    
    public function getIntroduction()
    {
        return $this->a['introduction'];
    }
    
    public function getDate()
    {
        return $this->a['date'];
    }
    


    /*
     *  numeracja tabel: examples, download, addresses
     */
    public function processEDANumbering()
    {
        $this->a['examples']['no'] = $this->getTablesCount() + 1;

        if ($this->a['examples_count'] > 0) {
            $this->a['download']['no'] = $this->a['examples']['no'] + 1;
        } else {
            $this->a['download']['no'] = $this->getTablesCount() + 1;
        }

        if (
            ($this->a['examples_count'] == 0) &&
            ($this->a['download_count'] == 0)
    	) {
                $this->a['addresses']['no'] = $this->getTablesCount() + 1;
            } else if (
                ($this->a['examples_count'] > 0) &&
                ($this->a['download_count'] > 0)
    	) {
            $this->a['addresses']['no'] = $this->getTablesCount() + 3;
        } else {
            $this->a['addresses']['no'] = $this->getTablesCount() + 2;
        }
    }



    

}