<?php


/**
 * This class adds structure of 'article' table to 'pagedarts' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    pagedarts.map
 */
class ArticleMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'pagedarts.map.ArticleMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(ArticlePeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(ArticlePeer::TABLE_NAME);
		$tMap->setPhpName('Article');
		$tMap->setClassname('Article');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('ARTICLE_ID', 'ArticleId', 'INTEGER', true, null);

		$tMap->addColumn('TITLE', 'Title', 'VARCHAR', false, 255);

		$tMap->addColumn('INTRODUCTION', 'Introduction', 'LONGVARCHAR', false, null);

		$tMap->addColumn('TOC', 'Toc', 'LONGVARCHAR', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

		$tMap->addColumn('DATE', 'Date', 'DATE', false, null);

		$tMap->addColumn('ONEPAGE', 'Onepage', 'LONGVARCHAR', false, null);

		$tMap->addColumn('ADDRESSES', 'Addresses', 'LONGVARCHAR', false, null);

		$tMap->addColumn('DOWNLOAD', 'Download', 'LONGVARCHAR', false, null);

		$tMap->addColumn('EXAMPLES', 'Examples', 'LONGVARCHAR', false, null);

	} // doBuild()

} // ArticleMapBuilder
