
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- article
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `article`;


CREATE TABLE `article`
(
	`article_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`title` VARCHAR(255),
	`introduction` TEXT,
	`toc` TEXT,
	`slug` VARCHAR(128)  NOT NULL,
	`date` DATE,
	`onepage` TEXT,
	`addresses` TEXT,
	`download` TEXT,
	`examples` TEXT,
	PRIMARY KEY (`article_id`),
	UNIQUE KEY `article_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- page
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `page`;


CREATE TABLE `page`
(
	`page_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`page` TEXT,
	`article_id` INTEGER,
	`number` INTEGER,
	PRIMARY KEY (`page_id`),
	INDEX `FI_page_article` (`article_id`),
	CONSTRAINT `fk_page_article`
		FOREIGN KEY (`article_id`)
		REFERENCES `article` (`article_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- file
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `file`;


CREATE TABLE `file`
(
	`file_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`data` LONGBLOB,
	`slug` VARCHAR(128)  NOT NULL,
	`mime` VARCHAR(128),
	`article_id` INTEGER,
	PRIMARY KEY (`file_id`),
	INDEX `FI_file_article1` (`article_id`),
	CONSTRAINT `fk_file_article1`
		FOREIGN KEY (`article_id`)
		REFERENCES `article` (`article_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
