<?php


/**
 * This class adds structure of 'plik' table to 'danebinarne' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    danebinarne.map
 */
class PlikMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'danebinarne.map.PlikMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(PlikPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(PlikPeer::TABLE_NAME);
		$tMap->setPhpName('Plik');
		$tMap->setClassname('Plik');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('PLIK_ID', 'PlikId', 'INTEGER', true, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', false, 128);

		$tMap->addColumn('DANE', 'Dane', 'BLOB', false, null);

		$tMap->addColumn('TYPMIME', 'Typmime', 'VARCHAR', false, 128);

	} // doBuild()

} // PlikMapBuilder
