<?php

class Actions extends ActionsBase
{

    public function execute_drzewo()
    {
        $this->set('gromady', GromadaPeer::doSelect(new Criteria()));
    }

    
    public function execute_rss()
    {
        require_once 'XML/Serializer.php';

        $serializer = new XML_Serializer();
        $options = array(
            'addDecl'        => true,
            'indent'         => '    ',
            'rootName'       => 'rss',
            'encoding'       => 'utf-8',

            'defaultTagName' => array(
                'channel' => 'item',
            ),

            'scalarAsAttributes' => array(
                'rss' => array('version'),
            )
        );

        $serializer->setOptions($options);

        $dane = array();
        $dane['version'] = '2.0';
        $dane['channel'] = array(
            'title' => 'Klasyfikacja zwierząt',
            'link' => 'http://example.net/klasy/fi/ka/cja.html',
            'description' => 'Lorem...',
            'language' => 'pl',
            'copyright' => 'Włodzimierz Gajda',
        );
        $gromady = GromadaPeer::doSelect(new Criteria());
        foreach ($gromady as $gromada) {
            $url = 'index.php?module=gromada&action=show&slug=' . $gromada->getSlug();
            $url = url($url, 'absolute');
            $item = array(
                'title' => 'Gromada: ' . $gromada,
                'link' => $url,
            );
            $dane['channel'][] = $item;
        }

        $serializer->serialize($dane);
        $wynik = $serializer->getSerializedData();

        $this->noLayout();
        header('Content-Type: application/xml');
        echo $wynik;
    }
    
    public function execute_generujsitemap()
    {
        $urls = array();
        $urls[] = 'index.php?module=main&action=drzewo';
        $urls[] = 'index.php?module=gromada&action=list';
        $urls[] = 'index.php?module=rzad&action=list';
        $urls[] = 'index.php?module=rodzina&action=list';

        $gromady = GromadaPeer::doSelect(new Criteria());
        foreach ($gromady as $gromada) {
            $urls[] = 'index.php?module=gromada&action=show&slug=' . $gromada->getSlug();
        }

        $rzedy = RzadPeer::doSelect(new Criteria());
        foreach ($rzedy as $rzad) {
            $urls[] = 'index.php?module=rzad&action=show&slug=' . $rzad->getSlug();
        }

        $rodziny = RodzinaPeer::doSelect(new Criteria());
        foreach ($rodziny as $rodzina) {
            $urls[] = 'index.php?module=rodzina&action=show&slug=' . $rodzina->getSlug();
        }

        $sitemap = new File_Sitemap();
        foreach ($urls as $u) {
            $u = url($u, 'absolute');
            $sitemap->add($u, 0.9, 'daily');
        }
        $sitemap->save('sitemap.xml', false, true);
    }

        
}
