<?php

require 'artykulymi/om/BaseAutor.php';


/**
 * Skeleton subclass for representing a row from the 'autor' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    artykulymi
 */
class Autor extends BaseAutor {

	/**
	 * Initializes internal state of Autor object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getImie() . ' ' . $this->getNazwisko();
	}
	
    public function przeliczArtykuly()
    {
        $ahas = $this->getArtykulHasAutorsJoinArtykul();
        $this->setLiczbaartykulow(count($ahas));
        $liczba_stron = 0;
        foreach ($ahas as $aha) {
            $liczba_stron += $aha->getArtykul()->getLiczbastron();
        }
        $this->setLiczbastron($liczba_stron);
        $this->save();
    }
    
    public function setSlug($slug)
    {
        if (trim($slug) == '') {
            parent::setSlug('unknown');
        } else {
            parent::setSlug($slug);
            ;
        }
    }


} // Autor
