<?php

set_include_path(
    './include' . PATH_SEPARATOR .
    get_include_path()
);



require_once 'vh-array.inc.php';
require_once "Spreadsheet/Excel/Writer.php";

$ile_aut = 139;

$marki = string2HArray(file_get_contents('marki.txt'), ',');
$wyposazenie = string2HArray(file_get_contents('wyposazenie.txt'), ',');

$typ = file('typ.txt');
$typ = array_map('trim', $typ);
$typ_c = count($typ);

$kolor = file('kolory.txt');
$kolor = array_map('trim', $kolor);
$kolor_c = count($kolor);

$paliwo = file('paliwo.txt');
$paliwo = array_map('trim', $paliwo);
$paliwo_c = count($paliwo);

$uwagi = file('uwagi.txt');
$uwagi = array_map('trim', $uwagi);
$uwagi_c = count($uwagi);

$xls = new Spreadsheet_Excel_Writer('auta.xls');
$sheet = $xls->addWorksheet('Samochody');

$format = $xls->addFormat();
$format->setBold();
$format->setSize('12');

$sheet->write(0, 0, 'Marka', $format);
$sheet->write(0, 1, 'Model', $format);
$sheet->write(0, 2, 'Rocznik', $format);
$sheet->write(0, 3, 'Cena', $format);
$sheet->write(0, 4, 'Pojemno', $format);
$sheet->write(0, 5, 'Przebieg', $format);
$sheet->write(0, 6, 'Kolor', $format);
$sheet->write(0, 7, 'Typ', $format);
$sheet->write(0, 8, 'Paliwo', $format);
$sheet->write(0, 9, 'Wyposaenie', $format);
$sheet->write(0, 10, 'Uwagi', $format);

$sheet->setColumn(0,8,16);
$sheet->setColumn(9,9,120);
$sheet->setColumn(10,10,120);

for ($i = 1; $i <= $ile_aut; $i++) {
    $tmp = rand(0, $marki['rows'] - 1);
    
    $sheet->write($i, 0, $marki['items'][$tmp][0]);
    $sheet->write($i, 1, $marki['items'][$tmp][1]);
    
    //rocznik
    $sheet->write($i, 2, rand(1990, 2005));        
    
    //cena
    $sheet->write($i, 3, 100 * rand(55, 999));            
    
    //pojemno
    $sheet->write($i, 4, rand(10, 45) / 10);                
    
    //przebieg
    $sheet->write($i, 5, rand(9, 350) * 1000);
    
    //kolor
    $tmp = rand(0, $kolor_c - 1);    
    if ($kolor[$tmp] == '?') {
        $sheet->write($i, 6, '');
    } else {
        $sheet->write($i, 6, $kolor[$tmp]);
    }
    
    //typ
    $tmp = rand(0, $typ_c - 1);    
    if ($typ[$tmp] == '?') {
        $sheet->write($i, 7, '');
    } else {
        $sheet->write($i, 7, $typ[$tmp]);            
    }    
    
    //paliwo
    $tmp = rand(0, $paliwo_c - 1);    
    if ($paliwo[$tmp] == '?') {
        $sheet->write($i, 8, '');
    } else {
        $sheet->write($i, 8, $paliwo[$tmp]);        
    }        
    
    //wyposaenie
    $tab = array();
    $tmp = rand(0, $wyposazenie['rows'] - 1);
    for ($j = 0; $j < $tmp; $j++) {
        $tmp2 = rand(0, $wyposazenie['rows'] - 1);
        array_push($tab, $wyposazenie['items'][$tmp2][0]);
    }
    sort($tab);
    $tab = array_unique($tab);
    $wyp = implode(', ', $tab);
    $wyp = trim($wyp, ', ');
    $sheet->write($i, 9, $wyp);            
    
    //uwagi
    $tab = array();
    $tmp = rand(0, $uwagi_c - 1);
    for ($j = 0; $j < $tmp; $j++) {
        $tmp2 = rand(0, $uwagi_c - 1);
        array_push($tab, $uwagi[$tmp2]);
    }
    sort($tab);
    $tab = array_unique($tab);
    $uw = implode(', ', $tab);
    $uw = trim($uw, ', ');
    $sheet->write($i, 10, $uw);
}

$sheet = $xls->addWorksheet('Wyposaenie');
for ($i = 0; $i < $wyposazenie['rows']; $i++) {
    $sheet->write($i, 0, $wyposazenie['items'][$i][0]);
    $sheet->write($i, 1, $wyposazenie['items'][$i][1]);
}

$xls->close();
