<?php

require 'records/om/BaseSong.php';


/**
 * Skeleton subclass for representing a row from the 'song' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    records
 */
class Song extends BaseSong {

	/**
	 * Initializes internal state of Song object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getTitle();
	}		
	
	public function setSlug($slug)
	{
        if (trim($slug) == '') {
            $slug = 'nieznany';
        }
        
        $next_slug = $slug;
        $c = new Criteria();
        $c->add(SongPeer::SLUG, $next_slug);
        $ile = SongPeer::doCount($c);

        $unikatowy = ($ile == 0);
        
        $min = 2;
        $max = 1000;

        while (!$unikatowy) {
        
	        $next_slug = $slug . $min;
            $min++;
            
	        if ($min > $max + 1) {
	             die("****** ERROR    Song::setSlug({$next_slug})");
	        };


	        
            $c->clear();
            $c->add(SongPeer::SLUG, $next_slug);
            $ile = SongPeer::doCount($c);
            $unikatowy = ($ile == 0);

            
//            echo '....................................' . $next_slug . "\n";
            
        }

        parent::setSlug($next_slug);
	}

	

} // Song
