﻿using Microsoft.EntityFrameworkCore; // GenerateCreateScript()
using Northwind.Console.HierarchyMapping; // HierarchyDb, Student, Employee

DbContextOptionsBuilder<HierarchyDb> options = new();
options.UseSqlServer("Data Source=.;Initial Catalog=HierarchyMapping;Integrated Security=true;TrustServerCertificate=true;");

using (HierarchyDb db = new(options.Options))
{
  bool deleted = await db.Database.EnsureDeletedAsync();
  WriteLine($"Baza danych usunięta: {deleted}");
  
  bool created = await db.Database.EnsureCreatedAsync();
  WriteLine($"Baza danych utworzona: {created}");

  WriteLine("Skrypt SQL użyty do utworzenia bazy:");
  WriteLine(db.Database.GenerateCreateScript());

  if (db.Students is null || db.Students.Count() == 0)
  {
    WriteLine("Nie ma danych studentów.");
  }
  else
  {
    foreach (Student student in db.Students)
    {
      WriteLine("{0} studiuje kierunek {1}",
        student.Name, student.Subject);
    }
  }

  if (db.Employees is null || db.Employees.Count() == 0)
  {
    WriteLine("Nie ma danych pracowników.");
  }
  else
  {
    foreach (Employee employee in db.Employees)
    {
      WriteLine("{0} został zatrudniony dnia {1}",
        employee.Name, employee.HireDate);
    }
  }

  if (db.People is null || db.People.Count() == 0)
  {
    WriteLine("Nie ma danych osób.");
  }
  else
  {
    foreach (Person person in db.People)
    {
      WriteLine("{0} ma identyfikator {1}",
        person.Name, person.Id);
    }
  }
}