﻿using Microsoft.AspNetCore.SignalR; // Hub
using System.Runtime.CompilerServices; // [EnumeratorCancellation]
using Northwind.SignalR.Streams; // StockPrice

namespace Northwind.SignalR.Service.Hubs;

public class StockPriceHub : Hub
{
  public async IAsyncEnumerable<StockPrice> GetStockPriceUpdates(
    string stock,
    [EnumeratorCancellation] CancellationToken cancellationToken)
  {
    double currentPrice = 267.10; // Symulowana cena początkowa.

    for (int i = 0; i < 10; i++)
    {
      // Regularne sprawdzanie tokenu anulującego, aby serwer
      // przestał generować elementy, gdy klient się rozłączy.
      cancellationToken.ThrowIfCancellationRequested();

      // Zwiększenie lub zmniejszenie ceny o losową wartość.
      currentPrice += (Random.Shared.NextDouble() * 10.0) - 5.0;

      StockPrice stockPrice = new(stock, currentPrice);

      Console.WriteLine("[{0}] Akcje {1}, cena {2:C}",
        DateTime.UtcNow, stockPrice.Stock, stockPrice.Price);

      yield return stockPrice;

      await Task.Delay(4000, cancellationToken); // Milisekundy.
    }
  }

  public async Task UploadStocks(IAsyncEnumerable<string> stocks)
  {
    await foreach (string stock in stocks)
    {
      Console.WriteLine($"Ładowanie {stock}...");
    }
  }
}
