﻿using Packt.Shared;

Write("Wpisz tekst do podpisania: ");
string? data = ReadLine();

if (string.IsNullOrEmpty(data))
{
  WriteLine("Musisz wpisać dowolny tekst.");
  return;
}

string signature = Protector.GenerateSignature(data);

WriteLine($"Podpis: {signature}");
WriteLine("Klucz publiczny służący do weryfikacji podpisu:");
WriteLine(Protector.PublicKey);

if (Protector.ValidateSignature(data, signature))
{
  WriteLine("Podpis poprawny, dane nie zostały zmodyfikowane.");
}
else
{
  WriteLine("Nieprawidłowy podpis lub zmodyfikowane dane.");
}

// Modyfikacja danych. Zastąpienie pierwszego znaku literą X lub Y.
string manipulatedData = data.Replace(data[0], 'X');
if (manipulatedData == data)
{
  manipulatedData = data.Replace(data[0], 'Y');
}

if (Protector.ValidateSignature(manipulatedData, signature))
{
  WriteLine("Podpis poprawny, dane nie zostały zmodyfikowane.");
}
else
{
  WriteLine("Nieprawidłowy podpis lub zmodyfikowane dane: {0}", 
    manipulatedData);
}
