﻿using AutoMapper; // MapperConfiguration, IMapper
using MappingObjects.Mappers; // CartToSummaryMapper
using Packt.Entities; // Customer, Cart, LineItem
using Packt.ViewModels; // Summary

// Utworzenie modelu obiektu na podstawie typów modeli "jednostek",
// które mogą pochodzić z magazynu danych.

Cart cart = new(
  Customer: new(
    FirstName: "John",
    LastName: "Smith"
  ), 
  Items: new()
  {
    new(ProductName: "Apples", UnitPrice: 0.49M, Quantity: 10),
    new(ProductName: "Bananas", UnitPrice: 0.99M, Quantity: 4)
  }
);

WriteLine($"{cart.Customer}");
foreach (LineItem item in cart.Items)
{
  WriteLine($"  {item}");
}

// Pobranie konfiguracji mapera w celu przekształcenia obiektu Cart w Summary.

MapperConfiguration config = CartToSummaryMapper.GetMapperConfiguration();

// Utworzenie mapera przy użyciu konfiguracji.

IMapper mapper = config.CreateMapper();

// Mapowanie.

Summary summary = mapper.Map<Cart, Summary>(cart);

// Wyświetlenie wyniku.

WriteLine($"Podsumowanie: klient {summary.FullName} wydał {summary.Total} zł.");