﻿using Microsoft.EntityFrameworkCore; // UseSqlServer
using Microsoft.Extensions.DependencyInjection; // IServiceCollection

namespace Packt.Shared;

public static class NorthwindContextExtensions
{
  /// <summary>
  /// Metoda dodająca klasę NorthwindContext do wskazanej kolekcji IServiceCollection. Używa wykorzystuje dostawcę SqlServer.
  /// </summary>
  /// <param name="services"></param>
  /// <param name="connectionString">Pary wykorzystywane zamiast domyślnych.</param>
  /// <returns> Kolekcja IServiceCollection umożliwiająca dodawanie kolejnych usług.</returns>
  public static IServiceCollection AddNorthwindContext(
    this IServiceCollection services,
    string connectionString = "Data Source=.;Initial Catalog=Northwind;" +
      "Integrated Security=true;TrustServerCertificate=True;MultipleActiveResultsets=true;")
  {
    services.AddDbContext<NorthwindContext>(options =>
    {
      options.UseSqlServer(connectionString);

      options.LogTo(Console.WriteLine,
        new[] { Microsoft.EntityFrameworkCore
          .Diagnostics.RelationalEventId.CommandExecuting });
    });

    return services;
  }
}
