﻿using Microsoft.AspNetCore.SignalR.Client; // HubConnection
using Northwind.SignalR.Streams; // StockPrice

Write("Podaj symbol akcji (naciśnij Enter, aby podać MSFT): "); 
string? stock = ReadLine();

if (string.IsNullOrEmpty(stock))
{
  stock = "MSFT";
}

HubConnection hubConnection = new HubConnectionBuilder()
  .WithUrl("https://localhost:5131/stockprice")
  .Build();

await hubConnection.StartAsync();

try
{
  CancellationTokenSource cts = new();

  IAsyncEnumerable<StockPrice> stockPrices =
    hubConnection.StreamAsync<StockPrice>(
      "GetStockPriceUpdates", stock, cts.Token);

  await foreach (StockPrice sp in stockPrices)
  {
    WriteLine($"Akcje {sp.Stock} kosztują {sp.Price:C}.");

    Write("Chcesz zakończyć (t/n)? ");
    ConsoleKey key = ReadKey().Key;
    if (key == ConsoleKey.T)
    {
      cts.Cancel();
    }
    WriteLine();
  }
}
catch (Exception ex)
{
  WriteLine($"Błąd {ex.GetType()}, komunikat {ex.Message}");
}
WriteLine();

WriteLine("Pobieranie strumienia zakończone.");

await hubConnection.SendAsync("UploadStocks", GetStocksAsync());

WriteLine("Ładowanie strumienia akcji (naciśnij ENTER, aby przerwać)."); 
ReadLine();

WriteLine("Zamknięcie aplikacji.");