﻿using Microsoft.AspNetCore.SignalR.Client; // HubConnection
using Northwind.Chat.Models; // UserModel, MessageModel

Write("Podaj nazwę (wymagana): ");
string? username = ReadLine();

if (string.IsNullOrEmpty(username))
{
  WriteLine("Musisz podać nazwę, aby zarejestrować się w czacie.");
  return;
}

Write("Podaj grupy (opcjonalne): "); 
string? groups = ReadLine();

HubConnection hubConnection = new HubConnectionBuilder()
  .WithUrl("https://localhost:5131/chat")
  .Build();

hubConnection.On<MessageModel>("ReceiveMessage", message =>
{
  WriteLine($"Do {message.To}, od {message.From}: {message.Body}");
});

await hubConnection.StartAsync();

WriteLine("Czat rozpoczęty.");

UserModel registration = new()
{
  Name = username,
  Groups = groups
};

await hubConnection.InvokeAsync("Register", registration);

WriteLine("Rejestracja pomyślna.");
WriteLine("Oczekiwanie na komunikaty (naciśnij ENTER, aby przerwać).");
ReadLine();
