using Microsoft.AspNetCore.OData; // Metoda rozszerzajca AddOData.
using Packt.Shared; // Metoda rozszerzajca AddNorthwindContext.

var builder = WebApplication.CreateBuilder(args);

// Dodanie usug do kontenera.

builder.Services.AddNorthwindContext();

builder.Services.AddControllers()
  .AddOData(options => options
    // Rejestracja modeli OData.
    .AddRouteComponents(routePrefix: "catalog",
      model: GetEdmModelForCatalog())

    .AddRouteComponents(routePrefix: "ordersystem",
      model: GetEdmModelForOrderSystem())

    .AddRouteComponents(routePrefix: "catalog/v{version}",
      model: GetEdmModelForCatalog())

    // Ustawienie opcji zapyta.
    .Select() // Wczenie $select na potrzeby projekcji.
    .Expand() // Wczenie $expand na potrzeby nawigacji do powizanych jednostek.
    .Filter() // Wczenie $filter na potrzeby filtrowania.
    .OrderBy() // Wczenie $orderby na potrzeby sortowania.
    .SetMaxTop(100) // Wczenie $top na potrzeby wyszukiwania maksymalnych wartoci.
    .Count() // Wczenie $count na potrzeby zliczania.
  );

// Wicej o konfigurowaniu Swagger/OpenAPI dowiesz si na stronie https://aka.ms/aspnetcore/swashbuckle.
builder.Services.AddEndpointsApiExplorer();
builder.Services.AddSwaggerGen();

var app = builder.Build();

// Konfiguracja potoku zapyta HTTP.
if (app.Environment.IsDevelopment())
{
  app.UseSwagger();
  app.UseSwaggerUI();
}

app.UseHttpsRedirection();

app.UseAuthorization();

app.MapControllers();

app.Run();
