using System.Net.Http.Headers; // MediaTypeWithQualityHeaderValue
using System.Net.Http.Json; // ReadFromJsonAsync<T>

namespace Northwind.Maui.Client;

public partial class CustomersPage : ContentPage {
  public CustomersPage()
  {
    InitializeComponent();

    CustomersListViewModel viewModel = new();

    try
    {
      HttpClient client = new() {
        BaseAddress = new Uri(DeviceInfo.Platform == DevicePlatform.Android ?
          "http://10.0.2.2:5182" : "http://localhost:5182")
      };

      //InfoLabel.Text = $"BaseAddress: {client.BaseAddress}";
      InfoLabel.Text = $"BaseAddress: http://10.0.2.2:5182";

      client.DefaultRequestHeaders.Accept.Add(
        new MediaTypeWithQualityHeaderValue("application/json"));

      HttpResponseMessage response = client
        .GetAsync("api/customers").Result;

      response.EnsureSuccessStatusCode();

      IEnumerable<CustomerDetailViewModel> customersFromService =
        response.Content.ReadFromJsonAsync
        <IEnumerable<CustomerDetailViewModel>>().Result;

      foreach (CustomerDetailViewModel c in customersFromService
        .OrderBy(customer => customer.CompanyName))
      {
        viewModel.Add(c);
      }

      InfoLabel.Text += $"\nLiczba odczytanych rekordw: {viewModel.Count}.";
    } 
    catch (Exception ex)
    {
      ErrorLabel.Text = "Bd: " + ex.Message + "\nZastosowane przykadowe dane.";
      ErrorLabel.IsVisible = true;

      viewModel.AddSampleData();
    }

    BindingContext = viewModel;
  }

  async void Customer_Tapped(object sender, ItemTappedEventArgs e)
  {
    if (e.Item is not CustomerDetailViewModel c) return;

    // Przejcie do strony prezentujcej szczegowe dane klienta.
    await Navigation.PushAsync(new CustomerDetailPage(
      BindingContext as CustomersListViewModel, c));
  }

  async void Customers_Refreshing(object sender, EventArgs e)
  {
    if (sender is not ListView listView) return;

    listView.IsRefreshing = true;

    // Symulacja odwieenia danych.
    await Task.Delay(1500);

    listView.IsRefreshing = false;
  }

  void Customer_Deleted(object sender, EventArgs e)
  {
    MenuItem menuItem = sender as MenuItem;
    if (menuItem.BindingContext is not CustomerDetailViewModel c) return;
    (BindingContext as CustomersListViewModel).Remove(c);
  }

  async void Customer_Phoned(object sender, EventArgs e)
  {
    MenuItem menuItem = sender as MenuItem;
    if (menuItem.BindingContext is not CustomerDetailViewModel c) return;

    if (await DisplayAlert("Zadzwo ",
      "Chcesz zadzwoni na numer " + c.Phone + "?",
      "Tak", "Nie"))
    {
      try
      {
        if (PhoneDialer.IsSupported)
        {
          PhoneDialer.Open(c.Phone);
        }
      } catch (Exception ex)
      {
        await DisplayAlert(title: "Bd",
          message: string.Format(
            "Nieudane poczenie z numerem {0}. Przyczyna: {1}", c.Phone, ex.Message),
          cancel: "OK");
      }
    }
  }

  async void Add_Clicked(object sender, EventArgs e)
  {
    await Navigation.PushAsync(new CustomerDetailPage(
      BindingContext as CustomersListViewModel));
  }
}