﻿using SixLabors.ImageSharp; // Klasa Image
using SixLabors.ImageSharp.Processing; // Metoda rozszerzająca Mutate

string imagesFolder = Path.Combine(
  Environment.CurrentDirectory, "images");

WriteLine($"Szukam obrazów w folderze:\n{imagesFolder}.");
WriteLine();

if (!Directory.Exists(imagesFolder))
{
  WriteLine();
  WriteLine("Folder nie istnieje!");
  return;
}

IEnumerable<string> images =
  Directory.EnumerateFiles(imagesFolder);

foreach (string imagePath in images)
{
  if (Path.GetFileNameWithoutExtension(imagePath).EndsWith("-thumbnail"))
  {
    WriteLine($"Pominięty plik:\n{imagePath}.");
    WriteLine();
    continue; // Ten plik został już przekształcony.
  }

  string thumbnailPath = Path.Combine(
    Environment.CurrentDirectory, "images",
    Path.GetFileNameWithoutExtension(imagePath)
    + "-thumbnail" + Path.GetExtension(imagePath));

  using (Image image = Image.Load(imagePath))
  {
    WriteLine($"Przekształcam plik:\n{imagePath}");
    WriteLine($"w plik:\n{thumbnailPath}.");
    image.Mutate(x => x.Resize(image.Width / 10, image.Height / 10));
    image.Mutate(x => x.Grayscale());
    image.Save(thumbnailPath);
    WriteLine();
  }
}

WriteLine("Przetwarzanie obrazów zakończone. Przejrzyj katalog images.");
