﻿using Serilog; // Log, LoggerConfiguration, RollingInterval
using Serilog.Core; // Logger
using Serilogging.Models; // ProductPageView

using Logger log = new LoggerConfiguration()
    .WriteTo.Console()
    .WriteTo.File("log.txt", rollingInterval: RollingInterval.Day)
    .CreateLogger();

Log.Logger = log;
Log.Information("Globalny rejestrator został skonfigurowany.");

Log.Warning("Ostrzeżenie!");
Log.Error("Błąd!");
Log.Fatal("Krytyczny problem!");

ProductPageView pageView = new() { 
  PageTitle = "Chai", 
  SiteSection = "Beverages", 
  ProductId = 1 };

Log.Information("Zdarzenie {@PageView} wystąpiło {Viewed}",
  pageView, DateTimeOffset.UtcNow);

// Tuż przed zakończeniem aplikacji:
Log.CloseAndFlush();
