using Microsoft.AspNetCore.Components.Web;
using Microsoft.AspNetCore.Components.WebAssembly.Hosting;
using Northwind.BlazorWasm.Client;
using Northwind.BlazorWasm.Client.Services; // LocalStorageService

var builder = WebAssemblyHostBuilder.CreateDefault(args);
builder.RootComponents.Add<App>("#app");
builder.RootComponents.Add<HeadOutlet>("head::after");

builder.Services.AddHttpClient("Northwind.BlazorWasm.ServerAPI", 
  client => client.BaseAddress = new Uri(builder.HostEnvironment.BaseAddress));

// Podaj instancje klasy HttpClient, ktre zawieraj tokeny dostpu podczas wysyania da do projektu serwera.
builder.Services.AddScoped(sp => sp.GetRequiredService<IHttpClientFactory>()
  .CreateClient("Northwind.BlazorWasm.ServerAPI"));

builder.Services.AddScoped<LocalStorageService>();

await builder.Build().RunAsync();

