using Microsoft.AspNetCore.Identity;
using Microsoft.EntityFrameworkCore;
using Northwind.Mvc.Data;
using Packt.Shared; // Metoda rozszerzajca AddNorthwindContext

var builder = WebApplication.CreateBuilder(args);

// Dodanie usug do kontenera.
var connectionString = builder.Configuration.GetConnectionString("DefaultConnection") ?? throw new InvalidOperationException("Connection string 'DefaultConnection' not found.");
builder.Services.AddDbContext<ApplicationDbContext>(options =>
    options.UseSqlServer(connectionString));
builder.Services.AddDatabaseDeveloperPageExceptionFilter();

builder.Services.AddDefaultIdentity<IdentityUser>(options => options.SignIn.RequireConfirmedAccount = true)
    .AddEntityFrameworkStores<ApplicationDbContext>();

builder.Services.AddControllersWithViews().AddViewLocalization();

builder.Services.AddLocalization(options => options.ResourcesPath = "Resources");

builder.Services.AddNorthwindContext();

var app = builder.Build();

string[] cultures = new[] { "en-US", "en-GB", "fr", "fr-FR" };

RequestLocalizationOptions localizationOptions = new();

// Element cultures[0] zawiera cig "en-US".
localizationOptions.SetDefaultCulture(cultures[0])
  .AddSupportedCultures(cultures) // Globalizacja formatw danych.
  .AddSupportedUICultures(cultures); // Lokalizacja interfejsu uytkownika.

app.UseRequestLocalization(localizationOptions);

// Konfiguracja potoku zapyta HTTP.
if (app.Environment.IsDevelopment())
{
  app.UseMigrationsEndPoint();
}
else
{
  app.UseExceptionHandler("/Home/Error");
  // Domylna warto HSTS to 30 dni. Moesz j zmieni w rodowisku produkcyjnym (patrz https://aka.ms/aspnetcore-hsts).
  app.UseHsts();
}

app.UseHttpsRedirection();
app.UseStaticFiles();

app.UseRouting();

app.UseAuthentication();
app.UseAuthorization();

app.MapControllerRoute(
    name: "default",
    pattern: "{controller=Home}/{action=Index}/{id?}");
app.MapRazorPages();

app.Run();
