# -*- coding: UTF-8 -*-
from django import forms
from django.utils.translation import ugettext_lazy as _

from models import Category, TYPE_CHOICES

from crispy_forms.helper import FormHelper
from crispy_forms import layout, bootstrap


class BulletinSearchForm(forms.Form):
    bulletin_type = forms.ChoiceField(
        label=_("Typ biuletynu"),
        required=False,
        choices=(("", "---------"),) + TYPE_CHOICES,
    )
    category = forms.ModelChoiceField(
        label=_("Kategoria"),
        required=False,
        queryset=Category.objects.all(),
    )

    def __init__(self, *args, **kwargs):
        super(BulletinSearchForm, self).__init__(*args, **kwargs)

        self.helper = FormHelper()
        self.helper.form_action = ""
        self.helper.form_method = "GET"

        self.helper.layout = layout.Layout(
            layout.Fieldset(
                _("Filtruj biuletyny"),
                layout.Field("bulletin_type"),
                layout.Field("category"),
            ),
            bootstrap.FormActions(
                layout.Submit('submit', _('Filtruj')),
            ),
        )