# -*- coding: UTF-8 -*-
from django.shortcuts import render
from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger

TOP_MOVIE_LIST = (
    {'place': 1, 'title': u"The Shawshank Redemption", 'year': 1994, 'rating': 9.2},
    {'place': 2, 'title': u"The Godfather", 'year': 1972, 'rating': 9.2},
    {'place': 3, 'title': u"The Godfather: Part II", 'year': 1974, 'rating': 9.0},
    {'place': 4, 'title': u"The Dark Knight", 'year': 2008, 'rating': 8.9},
    {'place': 5, 'title': u"Pulp Fiction", 'year': 1994, 'rating': 8.9},
    {'place': 6, 'title': u"The Good, the Bad and the Ugly", 'year': 1966, 'rating': 8.9},
    {'place': 7, 'title': u"Schindler's List", 'year': 1993, 'rating': 8.9},
    {'place': 8, 'title': u"12 Angry Men", 'year': 1957, 'rating': 8.9},
    {'place': 9, 'title': u"The Lord of the Rings: The Return of the King", 'year': 2003, 'rating': 8.9},
    {'place': 10, 'title': u"Fight Club", 'year': 1999, 'rating': 8.8},
    {'place': 11, 'title': u"The Lord of the Rings: The Fellowship of the Ring", 'year': 2001, 'rating': 8.8},
    {'place': 12, 'title': u"Star Wars: Episode V - The Empire Strikes Back", 'year': 1980, 'rating': 8.8},
    {'place': 13, 'title': u"Inception", 'year': 2010, 'rating': 8.7},
    {'place': 14, 'title': u"Forrest Gump", 'year': 1994, 'rating': 8.7},
    {'place': 15, 'title': u"One Flew Over the Cuckoo's Nest", 'year': 1975, 'rating': 8.7},
    {'place': 16, 'title': u"Goodfellas", 'year': 1990, 'rating': 8.7},
    {'place': 17, 'title': u"The Lord of the Rings: The Two Towers", 'year': 2002, 'rating': 8.7},
    {'place': 18, 'title': u"Star Wars: Episode IV - A New Hope", 'year': 1977, 'rating': 8.7},
    {'place': 19, 'title': u"The Matrix", 'year': 1999, 'rating': 8.7},
    {'place': 20, 'title': u"Seven Samurai", 'year': 1954, 'rating': 8.7},
    {'place': 21, 'title': u"City of God", 'year': 2002, 'rating': 8.7},
    {'place': 22, 'title': u"Se7en", 'year': 1995, 'rating': 8.6},
    {'place': 23, 'title': u"The Usual Suspects", 'year': 1995, 'rating': 8.6},
    {'place': 24, 'title': u"The Silence of the Lambs", 'year': 1991, 'rating': 8.6},
    {'place': 25, 'title': u"Once Upon a Time in the West", 'year': 1968, 'rating': 8.6},
    {'place': 26, 'title': u"It's a Wonderful Life", 'year': 1946, 'rating': 8.6},
    {'place': 27, 'title': u"Léon: The Professional", 'year': 1994, 'rating': 8.6},
    {'place': 28, 'title': u"Casablanca", 'year': 1942, 'rating': 8.6},
    {'place': 29, 'title': u"Life Is Beautiful", 'year': 1997, 'rating': 8.6},
    {'place': 30, 'title': u"Raiders of the Lost Ark", 'year': 1981, 'rating': 8.6},
    {'place': 31, 'title': u"Rear Window", 'year': 1954, 'rating': 8.6},
    {'place': 32, 'title': u"Psycho", 'year': 1960, 'rating': 8.6},
    {'place': 33, 'title': u"American History X", 'year': 1998, 'rating': 8.6},
    {'place': 34, 'title': u"City Lights", 'year': 1931, 'rating': 8.5},
    {'place': 35, 'title': u"Saving Private Ryan", 'year': 1998, 'rating': 8.5},
    {'place': 36, 'title': u"Spirited Away", 'year': 2001, 'rating': 8.5},
    {'place': 37, 'title': u"The Intouchables", 'year': 2011, 'rating': 8.5},
    {'place': 38, 'title': u"Memento", 'year': 2000, 'rating': 8.5},
    {'place': 39, 'title': u"Terminator 2: Judgment Day", 'year': 1991, 'rating': 8.5},
    {'place': 40, 'title': u"Modern Times", 'year': 1936, 'rating': 8.5},
    {'place': 41, 'title': u"Sunset Blvd.", 'year': 1950, 'rating': 8.5},
    {'place': 42, 'title': u"Dr. Strangelove or: How I Learned to Stop Worrying and Love the Bomb", 'year': 1964, 'rating': 8.5},
    {'place': 43, 'title': u"Apocalypse Now", 'year': 1979, 'rating': 8.5},
    {'place': 44, 'title': u"Der Pianist", 'year': 2002, 'rating': 8.5},
    {'place': 45, 'title': u"The Green Mile", 'year': 1999, 'rating': 8.5},
    {'place': 46, 'title': u"The Departed", 'year': 2006, 'rating': 8.5},
    {'place': 47, 'title': u"Gladiator", 'year': 2000, 'rating': 8.5},
    {'place': 48, 'title': u"Back to the Future", 'year': 1985, 'rating': 8.5},
    {'place': 49, 'title': u"Alien", 'year': 1979, 'rating': 8.5},
    {'place': 50, 'title': u"The Dark Knight Rises", 'year': 2012, 'rating': 8.5},
    {'place': 51, 'title': u"Django Unchained", 'year': 2012, 'rating': 8.4},
    {'place': 52, 'title': u"The Lives of Others", 'year': 2006, 'rating': 8.4},
    {'place': 53, 'title': u"The Prestige", 'year': 2006, 'rating': 8.4},
    {'place': 54, 'title': u"The Great Dictator", 'year': 1940, 'rating': 8.4},
    {'place': 55, 'title': u"The Shining", 'year': 1980, 'rating': 8.4},
    {'place': 56, 'title': u"Cinema Paradiso", 'year': 1988, 'rating': 8.4},
    {'place': 57, 'title': u"Paths of Glory", 'year': 1957, 'rating': 8.4},
    {'place': 58, 'title': u"American Beauty", 'year': 1999, 'rating': 8.4},
    {'place': 59, 'title': u"The Lion King", 'year': 1994, 'rating': 8.4},
    {'place': 60, 'title': u"WALL·E", 'year': 2008, 'rating': 8.4},
    {'place': 61, 'title': u"North by Northwest", 'year': 1959, 'rating': 8.4},
    {'place': 62, 'title': u"Amélie", 'year': 2001, 'rating': 8.4},
    {'place': 63, 'title': u"Citizen Kane", 'year': 1941, 'rating': 8.4},
    {'place': 64, 'title': u"Aliens", 'year': 1986, 'rating': 8.4},
    {'place': 65, 'title': u"Toy Story 3", 'year': 2010, 'rating': 8.4},
    {'place': 66, 'title': u"Vertigo", 'year': 1958, 'rating': 8.4},
    {'place': 67, 'title': u"M", 'year': 1931, 'rating': 8.4},
    {'place': 68, 'title': u"Das Boot", 'year': 1981, 'rating': 8.4},
    {'place': 69, 'title': u"Taxi Driver", 'year': 1976, 'rating': 8.4},
    {'place': 70, 'title': u"A Clockwork Orange", 'year': 1971, 'rating': 8.4},
    {'place': 71, 'title': u"Double Indemnity", 'year': 1944, 'rating': 8.4},
    {'place': 72, 'title': u"Oldboy", 'year': 2003, 'rating': 8.4},
    {'place': 73, 'title': u"Princess Mononoke", 'year': 1997, 'rating': 8.4},
    {'place': 74, 'title': u"To Kill a Mockingbird", 'year': 1962, 'rating': 8.4},
    {'place': 75, 'title': u"Reservoir Dogs", 'year': 1992, 'rating': 8.4},
    {'place': 76, 'title': u"Requiem for a Dream", 'year': 2000, 'rating': 8.4},
    {'place': 77, 'title': u"Es war einmal in Amerika", 'year': 1984, 'rating': 8.4},
    {'place': 78, 'title': u"Star Wars: Episode VI - Return of the Jedi", 'year': 1983, 'rating': 8.4},
    {'place': 79, 'title': u"Braveheart", 'year': 1995, 'rating': 8.4},
    {'place': 80, 'title': u"Lawrence of Arabia", 'year': 1962, 'rating': 8.4},
    {'place': 81, 'title': u"Grave of the Fireflies", 'year': 1988, 'rating': 8.4},
    {'place': 82, 'title': u"Eternal Sunshine of the Spotless Mind", 'year': 2004, 'rating': 8.4},
    {'place': 83, 'title': u"Witness for the Prosecution", 'year': 1957, 'rating': 8.3},
    {'place': 84, 'title': u"Full Metal Jacket", 'year': 1987, 'rating': 8.3},
    {'place': 85, 'title': u"Singin' in the Rain", 'year': 1952, 'rating': 8.3},
    {'place': 86, 'title': u"The Sting", 'year': 1973, 'rating': 8.3},
    {'place': 87, 'title': u"Bicycle Thieves", 'year': 1948, 'rating': 8.3},
    {'place': 88, 'title': u"Monty Python and the Holy Grail", 'year': 1975, 'rating': 8.3},
    {'place': 89, 'title': u"Amadeus", 'year': 1984, 'rating': 8.3},
    {'place': 90, 'title': u"All About Eve", 'year': 1950, 'rating': 8.3},
    {'place': 91, 'title': u"Snatch.", 'year': 2000, 'rating': 8.3},
    {'place': 92, 'title': u"Rashomon", 'year': 1950, 'rating': 8.3},
    {'place': 93, 'title': u"The Treasure of the Sierra Madre", 'year': 1948, 'rating': 8.3},
    {'place': 94, 'title': u"L.A. Confidential", 'year': 1997, 'rating': 8.3},
    {'place': 95, 'title': u"The Apartment", 'year': 1960, 'rating': 8.3},
    {'place': 96, 'title': u"Some Like It Hot", 'year': 1959, 'rating': 8.3},
    {'place': 97, 'title': u"The Third Man", 'year': 1949, 'rating': 8.3},
    {'place': 98, 'title': u"For a Few Dollars More", 'year': 1965, 'rating': 8.3},
    {'place': 99, 'title': u"The Wolf of Wall Street", 'year': 2013, 'rating': 8.3},
    {'place': 100, 'title': u"Indiana Jones and the Last Crusade", 'year': 1989, 'rating': 8.3},
    {'place': 101, 'title': u"Nader und Simin - eine Trennung", 'year': 2011, 'rating': 8.3},
    {'place': 102, 'title': u"Inglourious Basterds", 'year': 2009, 'rating': 8.3},
    {'place': 103, 'title': u"The Kid", 'year': 1921, 'rating': 8.3},
    {'place': 104, 'title': u"2001: A Space Odyssey", 'year': 1968, 'rating': 8.3},
    {'place': 105, 'title': u"Batman Begins", 'year': 2005, 'rating': 8.3},
    {'place': 106, 'title': u"Yojimbo", 'year': 1961, 'rating': 8.3},
    {'place': 107, 'title': u"Metropolis", 'year': 1927, 'rating': 8.3},
    {'place': 108, 'title': u"Unforgiven", 'year': 1992, 'rating': 8.3},
    {'place': 109, 'title': u"Raging Bull", 'year': 1980, 'rating': 8.3},
    {'place': 110, 'title': u"Chinatown", 'year': 1974, 'rating': 8.3},
    {'place': 111, 'title': u"Toy Story", 'year': 1995, 'rating': 8.3},
    {'place': 112, 'title': u"Scarface", 'year': 1983, 'rating': 8.3},
    {'place': 113, 'title': u"Up", 'year': 2009, 'rating': 8.3},
    {'place': 114, 'title': u"Die Hard", 'year': 1988, 'rating': 8.3},
    {'place': 115, 'title': u"Downfall", 'year': 2004, 'rating': 8.3},
    {'place': 116, 'title': u"Mr. Smith Goes to Washington", 'year': 1939, 'rating': 8.2},
    {'place': 117, 'title': u"The Great Escape", 'year': 1963, 'rating': 8.2},
    {'place': 118, 'title': u"Pans Labyrinth", 'year': 2006, 'rating': 8.2},
    {'place': 119, 'title': u"On the Waterfront", 'year': 1954, 'rating': 8.2},
    {'place': 120, 'title': u"Like Stars on Earth", 'year': 2007, 'rating': 8.2},
    {'place': 121, 'title': u"The Bridge on the River Kwai", 'year': 1957, 'rating': 8.2},
    {'place': 122, 'title': u"Heat", 'year': 1995, 'rating': 8.2},
    {'place': 123, 'title': u"3 Idiots", 'year': 2009, 'rating': 8.2},
    {'place': 124, 'title': u"The Hunt", 'year': 2012, 'rating': 8.2},
    {'place': 125, 'title': u"The Seventh Seal", 'year': 1957, 'rating': 8.2},
    {'place': 126, 'title': u"Wild Strawberries", 'year': 1957, 'rating': 8.2},
    {'place': 127, 'title': u"The Grand Budapest Hotel", 'year': 2014, 'rating': 8.2},
    {'place': 128, 'title': u"Ikiru - Einmal richtig leben", 'year': 1952, 'rating': 8.2},
    {'place': 129, 'title': u"The Elephant Man", 'year': 1980, 'rating': 8.2},
    {'place': 130, 'title': u"The General", 'year': 1926, 'rating': 8.2},
    {'place': 131, 'title': u"Ran", 'year': 1985, 'rating': 8.2},
    {'place': 132, 'title': u"My Neighbor Totoro", 'year': 1988, 'rating': 8.2},
    {'place': 133, 'title': u"The Gold Rush", 'year': 1925, 'rating': 8.2},
    {'place': 134, 'title': u"Blade Runner", 'year': 1982, 'rating': 8.2},
    {'place': 135, 'title': u"Lock, Stock and Two Smoking Barrels", 'year': 1998, 'rating': 8.2},
    {'place': 136, 'title': u"Gran Torino", 'year': 2008, 'rating': 8.2},
    {'place': 137, 'title': u"Good Will Hunting", 'year': 1997, 'rating': 8.2},
    {'place': 138, 'title': u"12 Years a Slave", 'year': 2013, 'rating': 8.2},
    {'place': 139, 'title': u"Rebecca", 'year': 1940, 'rating': 8.2},
    {'place': 140, 'title': u"The Big Lebowski", 'year': 1998, 'rating': 8.2},
    {'place': 141, 'title': u"The Secret in Their Eyes", 'year': 2009, 'rating': 8.2},
    {'place': 142, 'title': u"It Happened One Night", 'year': 1934, 'rating': 8.2},
    {'place': 143, 'title': u"Rush", 'year': 2013, 'rating': 8.2},
    {'place': 144, 'title': u"Warrior", 'year': 2011, 'rating': 8.2},
    {'place': 145, 'title': u"Casino", 'year': 1995, 'rating': 8.2},
    {'place': 146, 'title': u"Rang De Basanti", 'year': 2006, 'rating': 8.2},
    {'place': 147, 'title': u"V for Vendetta", 'year': 2005, 'rating': 8.2},
    {'place': 148, 'title': u"The Deer Hunter", 'year': 1978, 'rating': 8.2},
    {'place': 149, 'title': u"Cool Hand Luke", 'year': 1967, 'rating': 8.2},
    {'place': 150, 'title': u"The Maltese Falcon", 'year': 1941, 'rating': 8.2},
    {'place': 151, 'title': u"Fargo", 'year': 1996, 'rating': 8.2},
    {'place': 152, 'title': u"Her", 'year': 2013, 'rating': 8.2},
    {'place': 153, 'title': u"Gone with the Wind", 'year': 1939, 'rating': 8.2},
    {'place': 154, 'title': u"Trainspotting", 'year': 1996, 'rating': 8.2},
    {'place': 155, 'title': u"Howl's Moving Castle", 'year': 2004, 'rating': 8.2},
    {'place': 156, 'title': u"Into the Wild", 'year': 2007, 'rating': 8.2},
    {'place': 157, 'title': u"How to Train Your Dragon", 'year': 2010, 'rating': 8.1},
    {'place': 158, 'title': u"Hotel Rwanda", 'year': 2004, 'rating': 8.1},
    {'place': 159, 'title': u"The Sixth Sense", 'year': 1999, 'rating': 8.1},
    {'place': 160, 'title': u"Judgment at Nuremberg", 'year': 1961, 'rating': 8.1},
    {'place': 161, 'title': u"Butch Cassidy and the Sundance Kid", 'year': 1969, 'rating': 8.1},
    {'place': 162, 'title': u"The Thing", 'year': 1982, 'rating': 8.1},
    {'place': 163, 'title': u"Dial M for Murder", 'year': 1954, 'rating': 8.1},
    {'place': 164, 'title': u"Annie Hall", 'year': 1977, 'rating': 8.1},
    {'place': 165, 'title': u"A Beautiful Mind", 'year': 2001, 'rating': 8.1},
    {'place': 166, 'title': u"Platoon", 'year': 1986, 'rating': 8.1},
    {'place': 167, 'title': u"Kill Bill: Vol. 1", 'year': 2003, 'rating': 8.1},
    {'place': 168, 'title': u"No Country for Old Men", 'year': 2007, 'rating': 8.1},
    {'place': 169, 'title': u"Sin City", 'year': 2005, 'rating': 8.1},
    {'place': 170, 'title': u"Mary & Max, oder - Schrumpfen Schafe, wenn es regnet", 'year': 2009, 'rating': 8.1},
    {'place': 171, 'title': u"Finding Nemo", 'year': 2003, 'rating': 8.1},
    {'place': 172, 'title': u"Touch of Evil", 'year': 1958, 'rating': 8.1},
    {'place': 173, 'title': u"Diabolique", 'year': 1955, 'rating': 8.1},
    {'place': 174, 'title': u"Life of Brian", 'year': 1979, 'rating': 8.1},
    {'place': 175, 'title': u"Network", 'year': 1976, 'rating': 8.1},
    {'place': 176, 'title': u"The Princess Bride", 'year': 1987, 'rating': 8.1},
    {'place': 177, 'title': u"Amores Perros", 'year': 2000, 'rating': 8.1},
    {'place': 178, 'title': u"The Wizard of Oz", 'year': 1939, 'rating': 8.1},
    {'place': 179, 'title': u"Stand by Me", 'year': 1986, 'rating': 8.1},
    {'place': 180, 'title': u"The Avengers", 'year': 2012, 'rating': 8.1},
    {'place': 181, 'title': u"Ben-Hur", 'year': 1959, 'rating': 8.1},
    {'place': 182, 'title': u"The Grapes of Wrath", 'year': 1940, 'rating': 8.1},
    {'place': 183, 'title': u"Die Frau die singt - Incendies", 'year': 2010, 'rating': 8.1},
    {'place': 184, 'title': u"There Will Be Blood", 'year': 2007, 'rating': 8.1},
    {'place': 185, 'title': u"The Best Years of Our Lives", 'year': 1946, 'rating': 8.1},
    {'place': 186, 'title': u"The 400 Blows", 'year': 1959, 'rating': 8.1},
    {'place': 187, 'title': u"Million Dollar Baby", 'year': 2004, 'rating': 8.1},
    {'place': 188, 'title': u"Hachi: A Dog's Tale", 'year': 2009, 'rating': 8.1},
    {'place': 189, 'title': u"8½", 'year': 1963, 'rating': 8.1},
    {'place': 190, 'title': u"Lego", 'year': 2014, 'rating': 8.1},
    {'place': 191, 'title': u"Donnie Darko", 'year': 2001, 'rating': 8.1},
    {'place': 192, 'title': u"The Bourne Ultimatum", 'year': 2007, 'rating': 8.1},
    {'place': 193, 'title': u"Im Namen des Vaters", 'year': 1993, 'rating': 8.1},
    {'place': 194, 'title': u"Strangers on a Train", 'year': 1951, 'rating': 8.1},
    {'place': 195, 'title': u"Captain America: The Winter Soldier", 'year': 2014, 'rating': 8.1},
    {'place': 196, 'title': u"High Noon", 'year': 1952, 'rating': 8.1},
    {'place': 197, 'title': u"Persona", 'year': 1966, 'rating': 8.1},
    {'place': 198, 'title': u"Gandhi", 'year': 1982, 'rating': 8.1},
    {'place': 199, 'title': u"Notorious", 'year': 1946, 'rating': 8.1},
    {'place': 200, 'title': u"The King's Speech", 'year': 2010, 'rating': 8.1},
    {'place': 201, 'title': u"Infernal Affairs", 'year': 2002, 'rating': 8.1},
    {'place': 202, 'title': u"Jaws", 'year': 1975, 'rating': 8.1},
    {'place': 203, 'title': u"Gravity", 'year': 2013, 'rating': 8.1},
    {'place': 204, 'title': u"Nausicaä of the Valley of the Wind", 'year': 1984, 'rating': 8.1},
    {'place': 205, 'title': u"Twelve Monkeys", 'year': 1995, 'rating': 8.1},
    {'place': 206, 'title': u"Lagaan: Once Upon a Time in India", 'year': 2001, 'rating': 8.1},
    {'place': 207, 'title': u"Fanny and Alexander", 'year': 1982, 'rating': 8.1},
    {'place': 208, 'title': u"La Strada", 'year': 1954, 'rating': 8.0},
    {'place': 209, 'title': u"The Terminator", 'year': 1984, 'rating': 8.0},
    {'place': 210, 'title': u"Ip Man", 'year': 2008, 'rating': 8.0},
    {'place': 211, 'title': u"The Night of the Hunter", 'year': 1955, 'rating': 8.0},
    {'place': 212, 'title': u"Stalker", 'year': 1979, 'rating': 8.0},
    {'place': 213, 'title': u"Groundhog Day", 'year': 1993, 'rating': 8.0},
    {'place': 214, 'title': u"Who's Afraid of Virginia Woolf?", 'year': 1966, 'rating': 8.0},
    {'place': 215, 'title': u"The Big Sleep", 'year': 1946, 'rating': 8.0},
    {'place': 216, 'title': u"Dog Day Afternoon", 'year': 1975, 'rating': 8.0},
    {'place': 217, 'title': u"Rocky", 'year': 1976, 'rating': 8.0},
    {'place': 218, 'title': u"Harry Potter and the Deathly Hallows: Part 2", 'year': 2011, 'rating': 8.0},
    {'place': 219, 'title': u"The Battle of Algiers", 'year': 1966, 'rating': 8.0},
    {'place': 220, 'title': u"La Haine", 'year': 1995, 'rating': 8.0},
    {'place': 221, 'title': u"Barry Lyndon", 'year': 1975, 'rating': 8.0},
    {'place': 222, 'title': u"Pis of the Caribbean: The Curse of the Black Pearl", 'year': 2003, 'rating': 8.0},
    {'place': 223, 'title': u"Shutter Island", 'year': 2010, 'rating': 8.0},
    {'place': 224, 'title': u"Before Sunrise", 'year': 1995, 'rating': 8.0},
    {'place': 225, 'title': u"The Graduate", 'year': 1967, 'rating': 8.0},
    {'place': 226, 'title': u"The Celebration", 'year': 1998, 'rating': 8.0},
    {'place': 227, 'title': u"Monsters, Inc.", 'year': 2001, 'rating': 8.0},
    {'place': 228, 'title': u"The Hustler", 'year': 1961, 'rating': 8.0},
    {'place': 229, 'title': u"Swades", 'year': 2004, 'rating': 8.0},
    {'place': 230, 'title': u"Castle in the Sky", 'year': 1986, 'rating': 8.0},
    {'place': 231, 'title': u"Memories of Murder", 'year': 2003, 'rating': 8.0},
    {'place': 232, 'title': u"Roman Holiday", 'year': 1953, 'rating': 8.0},
    {'place': 233, 'title': u"A Christmas Story", 'year': 1983, 'rating': 8.0},
    {'place': 234, 'title': u"Underground", 'year': 1995, 'rating': 8.0},
    {'place': 235, 'title': u"In the Mood for Love", 'year': 2000, 'rating': 8.0},
    {'place': 236, 'title': u"Stalag 17", 'year': 1953, 'rating': 8.0},
    {'place': 237, 'title': u"Für eine Handvoll Dollar", 'year': 1964, 'rating': 8.0},
    {'place': 238, 'title': u"The Help", 'year': 2011, 'rating': 8.0},
    {'place': 239, 'title': u"Slumdog Millionaire", 'year': 2008, 'rating': 8.0},
    {'place': 240, 'title': u"The Killing", 'year': 1956, 'rating': 8.0},
    {'place': 241, 'title': u"Rope", 'year': 1948, 'rating': 8.0},
    {'place': 242, 'title': u"Elite Squad: The Enemy Within", 'year': 2010, 'rating': 8.0},
    {'place': 243, 'title': u"The Truman Show", 'year': 1998, 'rating': 8.0},
    {'place': 244, 'title': u"Black Swan", 'year': 2010, 'rating': 8.0},
    {'place': 245, 'title': u"Three Colors: Red", 'year': 1994, 'rating': 8.0},
    {'place': 246, 'title': u"Beauty and the Beast", 'year': 1991, 'rating': 8.0},
    {'place': 247, 'title': u"The Diving Bell and the Butterfly", 'year': 2007, 'rating': 8.0},
    {'place': 248, 'title': u"The Hobbit: The Desolation of Smaug", 'year': 2013, 'rating': 8.0},
    {'place': 249, 'title': u"La Dolce Vita", 'year': 1960, 'rating': 8.0},
    {'place': 250, 'title': u"Jurassic Park", 'year': 1993, 'rating': 8.0},
)


def movie_list(request):
    paginator = Paginator(TOP_MOVIE_LIST, 25)

    page_number = request.GET.get('page')
    try:
        page = paginator.page(page_number)
    except PageNotAnInteger:
        # If page is not an integer, show first page.
        page = paginator.page(1)
    except EmptyPage:
        # If page is out of range, show last existing page.
        page = paginator.page(paginator.num_pages)

    context = {
        'object_list': page,
    }
    return render(request, "movies/movie_list.html", context)
