unit unitbaza;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DBCtrls, Grids, DBGrids, Db, DBTables, StdCtrls, Mask,
  TeEngine, Series, TeeProcs, Chart, DBChart, ExtDlgs, RpCon, RpConDS,
  RpDefine, RpRave;

type

  TForm1 = class(TForm)
    DBNavigator1: TDBNavigator;
    Button4: TButton;
    Button5: TButton;
    Label6: TLabel;
    DBMemo1: TDBMemo;
    Label7: TLabel;
    DBImage1: TDBImage;
    Table1: TTable;
    DataSource1: TDataSource;
    Button6: TButton;
    DBChart1: TDBChart;
    Series1: TBarSeries;
    OpenPictureDialog1: TOpenPictureDialog;
    Table1LP: TSmallintField;
    Table1NAZWISKO: TStringField;
    Table1IMIE: TStringField;
    Table1WIEK: TSmallintField;
    Table1SR_OCEN: TFloatField;
    Table1UWAGI: TMemoField;
    Table1OBRAZ: TBlobField;
    Button1: TButton;
    Label1: TLabel;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    GroupBox1: TGroupBox;
    RadioButton7: TRadioButton;
    DBGrid1: TDBGrid;
    StaticText1: TStaticText;
    Button3: TButton;
    StaticText2: TStaticText;
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton7Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure RadioButton4Click(Sender: TObject);
    procedure DBImage1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DBChart1ClickSeries(Sender: TCustomChart;
      Series: TChartSeries; ValueIndex: Integer; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DBChart1CanResize(Sender: TObject; var NewWidth,
      NewHeight: Integer; var Resize: Boolean);
    private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;


implementation

{$R *.DFM}

// wyszukiwanie
procedure TForm1.Button4Click(Sender: TObject);
var nazwisko:string[20];
begin
   nazwisko:=Inputbox('Wprowadzanie nazwiska','Podaj nazwisko','');
  if Table1.Locate('Nazwisko',nazwisko,[loCaseInsensitive,loPartialKey]) then
    ShowMessage('Znaleziono nazwisko: '+Table1['Nazwisko'])
   else
    ShowMessage('Nie znaleziono nazwiska: '+nazwisko)
   //lub jak w P24.13
{     Table1.IndexName:='Nazwisko';
  if Table1.FindKey(['Lgfghf']) then
    ShowMessage('Imi to '+Table1.FieldByName('Imie').AsString)
  else
    ShowMessage('Nie ma takiego nazwiska');}

end;

// rysowanie wykresu
procedure TForm1.Button6Click(Sender: TObject);
begin
    DBChart1.Title.Text.Clear;
    DBChart1.Title.Text.Add('Wykres dla wieku');
    Series1.DataSources.Clear;
    Series1.DataSource := Table1;

    //Series1.PieValues.ValueSource:='wiek'; dla wykresu kolowego
    //w zakladce Axis\Labels min separation 40% to etykiety nie s zbyt blisko siebie
    Series1.yValues.ValueSource:='wiek';//sr_ocen';
    Series1.XValues.ValueSource:='LP';
   // DBChart1.Refresh;
end;

// sortowanie w/g nazwisk
procedure TForm1.RadioButton2Click(Sender: TObject);
begin
  Table1.IndexName:='Nazwisko';
end;

// sortowanie w/g imion
procedure TForm1.RadioButton3Click(Sender: TObject);
begin
   Table1.IndexName:='Imie';
end;

// sortowanie w/g sredniej ocen
procedure TForm1.RadioButton4Click(Sender: TObject);
begin
   Table1.IndexName:='SR_ocen';
end;
// bez sortowania
procedure TForm1.RadioButton7Click(Sender: TObject);
begin
  Table1.IndexName:='LP';
end;
// wczytanie obrazka do pola obraz
procedure TForm1.DBImage1Click(Sender: TObject);
begin
  Table1.Edit;
  if OpenPictureDialog1.Execute then
  begin
   DBImage1.Picture.Loadfromfile(OpenPictureDialog1.Filename);
   Table1.Post;
  end
  else Showmessage('Nie wybrano pliku');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Table1.TableName:='Nowa2.DBF';
  Table1.IndexName:='LP';
  DBGrid1.Columns.Add;
  DBGrid1.Columns[0].Fieldname:='LP';
  DBGrid1.Columns.Add;
  DBGrid1.Columns[1].Fieldname:='NAZWISKO';
  DBGrid1.Columns.Add;
  DBGrid1.Columns[2].Fieldname:='IMIE';
  DBGrid1.Columns.Add;
  DBGrid1.Columns[3].Fieldname:='WIEK';
  DBGrid1.Columns.Add;
  DBGrid1.Columns[4].Fieldname:='SR_OCEN';
  //nazwa kolumny moe by inna ni nazwa kolumny w bazie
  //DBGrid1.Columns.Items[4].Title.Caption:='REDNIA';
  DBMemo1.DataField:='UWAGI';
  DBImage1.DataField:='OBRAZ';
  Table1.Active:=true;

end;

// obliczenie sredniej wieku osb w bazie przefiltrowanej lub nie
procedure TForm1.Button1Click(Sender: TObject);
var suma, ilrek:integer;
begin
  suma:=0; ilrek:=0;
  Table1.First;
  while not Table1.Eof do
  begin
  suma:=suma+Table1.FieldbyName('WIEK').AsInteger;
  ilrek:=ilrek+1;
  Table1.Next;
  end;

  label1.Caption:=Floattostr(suma/ilrek);// lub /Table1.Recordcount dla calej bazy);
end;


// koniec
procedure TForm1.Button5Click(Sender: TObject);
begin
  Table1.Refresh;
  Application.Terminate;
end;


procedure TForm1.DBChart1ClickSeries(Sender: TCustomChart;
  Series: TChartSeries; ValueIndex: Integer; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

 Const CarriageReturn=#13#10;
begin
  { On Clicked Pie, show the user the pie data }
  With Series1 do
  ShowMessage( XLabel[ValueIndex] + CarriageReturn+
               MarkPercent(ValueIndex,True) );
end;

procedure TForm1.DBChart1CanResize(Sender: TObject; var NewWidth,
  NewHeight: Integer; var Resize: Boolean);
begin
   resize:=true;
    DBChart1.Height:=NewHeight;
  DBChart1.Height:=NewWidth;
end;



procedure TForm1.Button3Click(Sender: TObject);
begin
  try
  //ustawienie pocztku zakresu od nazwiska Malik
  //baza musi by posortowana wg nazwisk
  Table1.SetRangeStart;
  Table1.Fields[1].AsString:='Malik';// Fields[1] to pole Nazwisko
  //ustawienie koca zakresu na nazwisku Nowakowski
  Table1.SetRangeEnd;
  Table1.Fields[1].AsString:='Nowakowski';
  //ustawienie filtra
  Table1.ApplyRange;
  except
    ShowMessage('Rekordy nie s posortowane w/g nazwiska');
  end;
end;

end.
