unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TEditR = class(TEdit) //pocztek definicji nowej klasy
  private
     FAlignment: TAlignment;  //TAlignment = (taLeftJustify, taRightJustify, taCenter)-
                              //definicja tego typu znajduje si w module Classes
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure SetAlignment(Value: TAlignment);
  public
    property Alignment: TAlignment read FAlignment write SetAlignment default 
              taLeftJustify;
  end; //koniec definicji klasy TEditR, treci procedur wpisano w czci implementation

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    RadioGroup1: TRadioGroup;
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
      okienko:TEditR;  
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//zmiana zawartoci rekordu TCreateParams, ktrego pola okrelaj niektre cechy
//kontrolki takie jak np. szeroko, wysoko, styl, procedur wpisano z klawiatury
procedure TEditR.CreateParams(var Params: TCreateParams);
const
  Alignments: array[Boolean, TAlignment] of DWORD =
    ((ES_LEFT, ES_RIGHT, ES_CENTER),(ES_RIGHT, ES_LEFT, ES_CENTER));
begin
  inherited CreateParams(Params);
  with Params do
  begin
    Style := Style or Alignments[UseRightToLeftAlignment, FAlignment];
  end;
end;

//ustawienie wartoci pola FAligment, procedur wpisano w caoci z klawiatury
procedure TEditR.SetAlignment(Value: TAlignment);
begin
  if FAlignment <> Value then
  begin
    FAlignment := Value;
    RecreateWnd;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   if okienko=nil then
   begin
     okienko:=TEditR.Create(Self);
     okienko.Parent:=Form1;
     okienko.Left:=20;
     okienko.Top:=40;
     okienko.Alignment:=taRightJustify;
     okienko.Text:='Ala';
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  okienko.Free; okienko:=nil;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin

end;

// wyrwnanie zawartoci okienka TEditR
procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  if okienko<>nil then
  begin
  case RadioGroup1.ItemIndex of
  0:  okienko.Alignment:=taLeftJustify;
  1:  okienko.Alignment:=taRightJustify;
  2:  okienko.Alignment:=taCenter;
  end;
  end;
end;

end.
