unit MojKomponent;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls,Graphics;

type
  TMojKomponent = class(tcustomcontrol)
  private
     FKlik:boolean;
     function Czy_zazn:boolean;
     procedure Ustaw_Zazn(zaz:boolean);
    public
     constructor Create(AOwner:TComponent); override;
     procedure Paint;override;
     procedure Click;override;
    published
     property zazn:boolean read Czy_zazn write Ustaw_zazn;
     property OnClick;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Standard', [TMojKomponent]);
end;
constructor TMojKomponent.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  FKlik:=false;
end;

function TMojKomponent.Czy_zazn:boolean;
begin
  Result:=FKlik;
end;

procedure TMojKomponent.Ustaw_Zazn(zaz:boolean);
begin
  FKlik:=zaz;
  Refresh;
end;

procedure TMojKomponent.Paint;
begin
  inherited Paint;
  Canvas.Pen.Width:=2;
  Canvas.Pen.Color:=clBlack;
  Canvas.Rectangle(0,0,width,height);
  if Fklik then
  begin
    Canvas.Pen.Color:=clRed;
    Canvas.MoveTo(3,3);
    Canvas.LineTo(Width-5,Height-5);
    Canvas.MoveTo(width-5,3);
    Canvas.LineTo(3,height-5);
  end
  else
  Canvas.Rectangle(0,0,width,height);
end;

procedure TMojKomponent.Click;
begin

 if FKlik then zazn:=false else zazn:=true;

 Refresh;
 inherited Click;
end;

end.
