unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, MPlayer;

type
  TForm1 = class(TForm)
    MediaPlayer1: TMediaPlayer;
    ListBox1: TListBox;
    ProgressBar1: TProgressBar;
    Timer1: TTimer;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    nr_utworu: integer;
    zmiana: boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Timer1.Enabled:=true;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Timer1.Enabled:=false;
  Mediaplayer1.Close;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
    Opendialog1.InitialDir:=GetCurrentdir; //otwarcie okna z biecym
// folderem
   if Opendialog1.Execute then
   begin
     Listbox1.Items.Clear; //wykasowanie poprzednich utworw z listy
     Listbox1.Items.LoadFromFile(Opendialog1.Filename);
   end;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
begin
  MediaPlayer1.Close;
  nr_utworu:=Listbox1.Itemindex;
  zmiana:=true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var dl:integer;
begin
//jesli nie wybrano utworu na liscie to nic si nie dzieje
 if Listbox1.ItemIndex>-1 then
 begin
 //jesli utwr jest odtwarzany (status=playing) to wyswietl
 //czas odtwarzania i przesu suwak na paseku progressbar
 //type TMPModes = (mpNotReady, mpStopped, mpPlaying, mpRecording, mpSeeking, mpPaused, mpOpen);
   if Mediaplayer1.Mode=mpPlaying then//'Playing' then
begin
     if zmiana then
     begin
       dl := MediaPlayer1.Length div 1000;  //zamiana na sek
       Label3.Caption := 'Dugo utworu'+#13+
                     IntToStr(dl mod 60)+' sek '+
                     IntToStr(dl div 60)+' min '+
                     IntToStr(dl div 3600)+' godz';
       Progressbar1.Max:=dl;//przypisanie Max Progressbara dugoci utworu w sek.
     end;
    // Progressbar1.Position:=Mediaplayer1.Position;
     //wywietlenie postepu utworu
     dl := MediaPlayer1.Position div 1000;  //zamiana na sek
     Progressbar1.Position:=dl; //przypisanie Position Progressbara d. utworu w sek.
     Label4.Caption := 'Czas biecy'+#13+
                     IntToStr(dl mod 60)+' sek '+
                     IntToStr(dl div 60)+' min '+
                     IntToStr(dl div 3600)+' godz';
   end
   else
   begin
     Mediaplayer1.FileName:= listbox1.items[nr_utworu];
     Mediaplayer1.Open;
     Mediaplayer1.Play;
     //zaznaczenie kolejnego utworu na liscie bez klikania w list
     Listbox1.ItemIndex:=nr_utworu;
     //nazwa utworu bez scieki na etykiecie
     Label1.Caption:=ExtractfileName(Listbox1.Items[nr_utworu]);
     nr_utworu:=(nr_utworu+1)mod Listbox1.Count;
     // Mediaplayer1.notify:=true;
     zmiana:=true;
   end; //if mpPaying
 end; //if Itemindex>-1

end;

end.
