unit EditR;

interface

uses
  SysUtils, Classes, Controls, StdCtrls, Windows;

type
  TEditR = class(TEdit)
  private
     FAlignment: TAlignment;
  protected
      procedure CreateParams(var Params: TCreateParams); override;
      procedure SetAlignment(Value: TAlignment);
  published
      property Alignment: TAlignment read FAlignment write SetAlignment default
                     taLeftJustify;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TEditR]);
end;
procedure TEditR.CreateParams(var Params: TCreateParams);
const
  Alignments: array[Boolean, TAlignment] of DWORD =
    ((ES_LEFT, ES_RIGHT, ES_CENTER),(ES_RIGHT, ES_LEFT, ES_CENTER));
begin
    inherited CreateParams(Params);
    with Params do
    begin
       Style := Style or Alignments[UseRightToLeftAlignment, FAlignment];
    end;
end;

procedure TEditR.SetAlignment(Value: TAlignment);
begin
  if FAlignment <> Value then
  begin
    FAlignment := Value;
    RecreateWnd;
  end;
end;

end.
