unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TMojKomponent=class(TCustomControl)
    private
     FKlik:boolean;
     function Czy_zazn:boolean;
     procedure Ustaw_Zazn(zaz:boolean);
    public
     constructor Create(AOwner:TComponent); override;
     procedure Paint;override;
     procedure Click;override;
     property zazn:boolean read Czy_zazn write Ustaw_zazn;
  end;


  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
    Label2: TLabel;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    n1,n2:TMojKomponent;
    { Private declarations }
  public
    { Public declarations }
  end;



var
  Form1: TForm1;

implementation

{$R *.dfm}
constructor TMojKomponent.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  FKlik:=true;
end;

function TMojKomponent.Czy_zazn:boolean;
begin
  Result:=FKlik;
end;

procedure TMojKomponent.Ustaw_Zazn(zaz:boolean);
begin
  FKlik:=zaz;
  Refresh;
end;

procedure TMojKomponent.Paint;
begin
  inherited Paint;
  if Fklik then
  begin
  Canvas.Pen.Color:=clRed;
  Canvas.Rectangle(0,0,width,height);
  Canvas.MoveTo(0,0);
  Canvas.LineTo(Width,Height);
  Canvas.MoveTo(0,height);
  Canvas.LineTo(width,0);
  end
  else
  Canvas.Rectangle(0,0,width,height);

end;

procedure TMojKomponent.Click;
begin
 inherited Click;
 if FKlik then FKlik:=false else FKlik:=true;
 Refresh;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  n1:=TMojKomponent.Create(Self);
  n1.Parent:=Form1;
  n1.Top:=50;
  n1.Left:=40;
  n1.Width:=20;
  n1.Height:=20;
  n2:=TMojKomponent.Create(Self);
  n2.Parent:=Form1;
  n2.Top:=75;
  n2.Left:=40;
  n2.Width:=20;
  n2.Height:=20;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if n1.zazn then label1.Caption:='Komponent zaznaczony'
  else Label1.Caption:='Komponent niezaznaczony';
  if n2.zazn then label2.Caption:='Komponent zaznaczony'
  else Label2.Caption:='Komponent niezaznaczony';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   n1.Ustaw_Zazn(true);
   n2.Ustaw_Zazn(true);
end;

end.
