/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

class TwilightCalculator {
    private static TwilightCalculator sInstance;
    public static final int DAY = 0;
    public static final int NIGHT = 1;
    private static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    private static final float J0 = 9.0E-4f;
    private static final float ALTIDUTE_CORRECTION_CIVIL_TWILIGHT = -0.10471976f;
    private static final float C1 = 0.0334196f;
    private static final float C2 = 3.49066E-4f;
    private static final float C3 = 5.236E-6f;
    private static final float OBLIQUITY = 0.4092797f;
    private static final long UTC_2000 = 946728000000L;
    public long sunset;
    public long sunrise;
    public int state;

    TwilightCalculator() {
    }

    static TwilightCalculator getInstance() {
        if (sInstance == null) {
            sInstance = new TwilightCalculator();
        }
        return sInstance;
    }

    public void calculateTwilight(long time, double latiude, double longitude) {
        float daysSince2000 = (float)(time - 946728000000L) / 8.64E7f;
        float meanAnomaly = 6.24006f + daysSince2000 * 0.01720197f;
        double trueAnomaly = (double)meanAnomaly + (double)0.0334196f * Math.sin(meanAnomaly) + 3.4906598739326E-4 * Math.sin(2.0f * meanAnomaly) + (double)5.236E-6f * Math.sin(3.0f * meanAnomaly);
        double solarLng = trueAnomaly + 1.796593063 + Math.PI;
        double arcLongitude = -longitude / 360.0;
        float n = Math.round((double)(daysSince2000 - 9.0E-4f) - arcLongitude);
        double solarTransitJ2000 = (double)(n + 9.0E-4f) + arcLongitude + 0.0053 * Math.sin(meanAnomaly) + -0.0069 * Math.sin(2.0 * solarLng);
        double solarDec = Math.asin(Math.sin(solarLng) * Math.sin(0.4092797040939331));
        double latRad = latiude * 0.01745329238474369;
        double cosHourAngle = (Math.sin(-0.10471975803375244) - Math.sin(latRad) * Math.sin(solarDec)) / (Math.cos(latRad) * Math.cos(solarDec));
        if (cosHourAngle >= 1.0) {
            this.state = 1;
            this.sunset = -1L;
            this.sunrise = -1L;
            return;
        }
        if (cosHourAngle <= -1.0) {
            this.state = 0;
            this.sunset = -1L;
            this.sunrise = -1L;
            return;
        }
        float hourAngle = (float)(Math.acos(cosHourAngle) / (Math.PI * 2));
        this.sunset = Math.round((solarTransitJ2000 + (double)hourAngle) * 8.64E7) + 946728000000L;
        this.sunrise = Math.round((solarTransitJ2000 - (double)hourAngle) * 8.64E7) + 946728000000L;
        this.state = this.sunrise < time && this.sunset > time ? 0 : 1;
    }
}

