/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.support.design.widget.CircularBorderDrawable;

class CircularBorderDrawableLollipop
extends CircularBorderDrawable {
    private ColorStateList mTint;
    private PorterDuff.Mode mTintMode = PorterDuff.Mode.SRC_IN;
    private PorterDuffColorFilter mTintFilter;

    CircularBorderDrawableLollipop() {
    }

    @Override
    public void draw(Canvas canvas) {
        boolean clearColorFilter;
        if (this.mTintFilter != null && this.mPaint.getColorFilter() == null) {
            this.mPaint.setColorFilter((ColorFilter)this.mTintFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        super.draw(canvas);
        if (clearColorFilter) {
            this.mPaint.setColorFilter(null);
        }
    }

    public void setTintList(ColorStateList tint) {
        this.mTint = tint;
        this.mTintFilter = this.updateTintFilter(tint, this.mTintMode);
        this.invalidateSelf();
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTint, tintMode);
        this.invalidateSelf();
    }

    private PorterDuffColorFilter updateTintFilter(ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color2 = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color2, tintMode);
    }
}

