/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.StateListAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.support.design.widget.CircularBorderDrawable;
import android.support.design.widget.CircularBorderDrawableLollipop;
import android.support.design.widget.FloatingActionButtonImpl;
import android.support.design.widget.ShadowViewDelegate;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

@TargetApi(value=21)
class FloatingActionButtonLollipop
extends FloatingActionButtonImpl {
    private Drawable mShapeDrawable;
    private RippleDrawable mRippleDrawable;
    private Drawable mBorderDrawable;
    private Interpolator mInterpolator;

    FloatingActionButtonLollipop(View view, ShadowViewDelegate shadowViewDelegate) {
        super(view, shadowViewDelegate);
        if (!view.isInEditMode()) {
            this.mInterpolator = AnimationUtils.loadInterpolator((Context)this.mView.getContext(), (int)17563661);
        }
    }

    @Override
    void setBackgroundDrawable(Drawable originalBackground, ColorStateList backgroundTint, PorterDuff.Mode backgroundTintMode, int rippleColor, int borderWidth) {
        Drawable rippleContent;
        this.mShapeDrawable = DrawableCompat.wrap((Drawable)originalBackground);
        DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)backgroundTint);
        if (backgroundTintMode != null) {
            DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)backgroundTintMode);
        }
        if (borderWidth > 0) {
            this.mBorderDrawable = this.createBorderDrawable(borderWidth, backgroundTint);
            rippleContent = new LayerDrawable(new Drawable[]{this.mBorderDrawable, this.mShapeDrawable});
        } else {
            this.mBorderDrawable = null;
            rippleContent = this.mShapeDrawable;
        }
        this.mRippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)rippleColor), rippleContent, null);
        this.mShadowViewDelegate.setBackgroundDrawable((Drawable)this.mRippleDrawable);
        this.mShadowViewDelegate.setShadowPadding(0, 0, 0, 0);
    }

    @Override
    void setBackgroundTintList(ColorStateList tint) {
        DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)tint);
        if (this.mBorderDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mBorderDrawable, (ColorStateList)tint);
        }
    }

    @Override
    void setBackgroundTintMode(PorterDuff.Mode tintMode) {
        DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)tintMode);
    }

    @Override
    void setRippleColor(int rippleColor) {
        DrawableCompat.setTint((Drawable)this.mRippleDrawable, (int)rippleColor);
    }

    @Override
    public void setElevation(float elevation) {
        ViewCompat.setElevation((View)this.mView, (float)elevation);
    }

    @Override
    void setPressedTranslationZ(float translationZ) {
        StateListAnimator stateListAnimator = new StateListAnimator();
        stateListAnimator.addState(PRESSED_ENABLED_STATE_SET, this.setupAnimator((Animator)ObjectAnimator.ofFloat((Object)this.mView, (String)"translationZ", (float[])new float[]{translationZ})));
        stateListAnimator.addState(FOCUSED_ENABLED_STATE_SET, this.setupAnimator((Animator)ObjectAnimator.ofFloat((Object)this.mView, (String)"translationZ", (float[])new float[]{translationZ})));
        stateListAnimator.addState(EMPTY_STATE_SET, this.setupAnimator((Animator)ObjectAnimator.ofFloat((Object)this.mView, (String)"translationZ", (float[])new float[]{0.0f})));
        this.mView.setStateListAnimator(stateListAnimator);
    }

    @Override
    void onDrawableStateChanged(int[] state) {
    }

    @Override
    void jumpDrawableToCurrentState() {
    }

    private Animator setupAnimator(Animator animator) {
        animator.setInterpolator((TimeInterpolator)this.mInterpolator);
        return animator;
    }

    @Override
    CircularBorderDrawable newCircularDrawable() {
        return new CircularBorderDrawableLollipop();
    }
}

