/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.support.annotation.Nullable;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.FloatingActionButtonEclairMr1;
import android.support.design.widget.FloatingActionButtonImpl;
import android.support.design.widget.ShadowViewDelegate;
import android.support.design.widget.VisibilityAwareImageButton;
import android.support.v4.view.ViewCompat;
import android.view.View;

class FloatingActionButtonIcs
extends FloatingActionButtonEclairMr1 {
    private boolean mIsHiding;

    FloatingActionButtonIcs(VisibilityAwareImageButton view, ShadowViewDelegate shadowViewDelegate) {
        super(view, shadowViewDelegate);
    }

    @Override
    boolean requirePreDrawListener() {
        return true;
    }

    @Override
    void onPreDraw() {
        this.updateFromViewRotation(this.mView.getRotation());
    }

    @Override
    void hide(final @Nullable FloatingActionButtonImpl.InternalVisibilityChangedListener listener, final boolean fromUser) {
        if (this.mIsHiding || this.mView.getVisibility() != 0) {
            if (listener != null) {
                listener.onHidden();
            }
            return;
        }
        if (!ViewCompat.isLaidOut((View)this.mView) || this.mView.isInEditMode()) {
            this.mView.internalSetVisibility(8, fromUser);
            if (listener != null) {
                listener.onHidden();
            }
        } else {
            this.mView.animate().cancel();
            this.mView.animate().scaleX(0.0f).scaleY(0.0f).alpha(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                private boolean mCancelled;

                public void onAnimationStart(Animator animation) {
                    FloatingActionButtonIcs.this.mIsHiding = true;
                    this.mCancelled = false;
                    FloatingActionButtonIcs.this.mView.internalSetVisibility(0, fromUser);
                }

                public void onAnimationCancel(Animator animation) {
                    FloatingActionButtonIcs.this.mIsHiding = false;
                    this.mCancelled = true;
                }

                public void onAnimationEnd(Animator animation) {
                    FloatingActionButtonIcs.this.mIsHiding = false;
                    if (!this.mCancelled) {
                        FloatingActionButtonIcs.this.mView.internalSetVisibility(8, fromUser);
                        if (listener != null) {
                            listener.onHidden();
                        }
                    }
                }
            });
        }
    }

    @Override
    void show(final @Nullable FloatingActionButtonImpl.InternalVisibilityChangedListener listener, final boolean fromUser) {
        if (this.mIsHiding || this.mView.getVisibility() != 0) {
            if (ViewCompat.isLaidOut((View)this.mView) && !this.mView.isInEditMode()) {
                this.mView.animate().cancel();
                if (this.mView.getVisibility() != 0) {
                    this.mView.setAlpha(0.0f);
                    this.mView.setScaleY(0.0f);
                    this.mView.setScaleX(0.0f);
                }
                this.mView.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration(200L).setInterpolator((TimeInterpolator)AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationStart(Animator animation) {
                        FloatingActionButtonIcs.this.mView.internalSetVisibility(0, fromUser);
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (listener != null) {
                            listener.onShown();
                        }
                    }
                });
            } else {
                this.mView.internalSetVisibility(0, fromUser);
                this.mView.setAlpha(1.0f);
                this.mView.setScaleY(1.0f);
                this.mView.setScaleX(1.0f);
                if (listener != null) {
                    listener.onShown();
                }
            }
        }
    }

    private void updateFromViewRotation(float rotation) {
        if (this.mShadowDrawable != null) {
            this.mShadowDrawable.setRotation(-rotation);
        }
        if (this.mBorderDrawable != null) {
            this.mBorderDrawable.setRotation(-rotation);
        }
    }
}

