/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.view.menu;

import android.content.Context;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v4.internal.view.SupportSubMenu;
import android.support.v4.util.ArrayMap;
import android.support.v7.view.menu.BaseWrapper;
import android.support.v7.view.menu.MenuWrapperFactory;
import android.view.MenuItem;
import android.view.SubMenu;
import java.util.Iterator;
import java.util.Map;

abstract class BaseMenuWrapper<T>
extends BaseWrapper<T> {
    final Context mContext;
    private Map<SupportMenuItem, MenuItem> mMenuItems;
    private Map<SupportSubMenu, SubMenu> mSubMenus;

    BaseMenuWrapper(Context context, T object) {
        super(object);
        this.mContext = context;
    }

    final MenuItem getMenuItemWrapper(MenuItem menuItem) {
        if (menuItem instanceof SupportMenuItem) {
            MenuItem wrappedItem;
            SupportMenuItem supportMenuItem = (SupportMenuItem)menuItem;
            if (this.mMenuItems == null) {
                this.mMenuItems = new ArrayMap();
            }
            if (null == (wrappedItem = this.mMenuItems.get(menuItem))) {
                wrappedItem = MenuWrapperFactory.wrapSupportMenuItem(this.mContext, supportMenuItem);
                this.mMenuItems.put(supportMenuItem, wrappedItem);
            }
            return wrappedItem;
        }
        return menuItem;
    }

    final SubMenu getSubMenuWrapper(SubMenu subMenu) {
        if (subMenu instanceof SupportSubMenu) {
            SubMenu wrappedMenu;
            SupportSubMenu supportSubMenu = (SupportSubMenu)subMenu;
            if (this.mSubMenus == null) {
                this.mSubMenus = new ArrayMap();
            }
            if (null == (wrappedMenu = this.mSubMenus.get(supportSubMenu))) {
                wrappedMenu = MenuWrapperFactory.wrapSupportSubMenu(this.mContext, supportSubMenu);
                this.mSubMenus.put(supportSubMenu, wrappedMenu);
            }
            return wrappedMenu;
        }
        return subMenu;
    }

    final void internalClear() {
        if (this.mMenuItems != null) {
            this.mMenuItems.clear();
        }
        if (this.mSubMenus != null) {
            this.mSubMenus.clear();
        }
    }

    final void internalRemoveGroup(int groupId) {
        if (this.mMenuItems == null) {
            return;
        }
        Iterator<SupportMenuItem> iterator = this.mMenuItems.keySet().iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem = (MenuItem)iterator.next();
            if (groupId != menuItem.getGroupId()) continue;
            iterator.remove();
        }
    }

    final void internalRemoveItem(int id2) {
        if (this.mMenuItems == null) {
            return;
        }
        Iterator<SupportMenuItem> iterator = this.mMenuItems.keySet().iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem = (MenuItem)iterator.next();
            if (id2 != menuItem.getItemId()) continue;
            iterator.remove();
            break;
        }
    }
}

