/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.util.Log;
import android.widget.PopupWindow;
import java.lang.reflect.Field;

class PopupWindowCompatApi21 {
    private static final String TAG = "PopupWindowCompatApi21";
    private static Field sOverlapAnchorField;

    PopupWindowCompatApi21() {
    }

    static void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
        if (sOverlapAnchorField != null) {
            try {
                sOverlapAnchorField.set(popupWindow, overlapAnchor);
            }
            catch (IllegalAccessException e) {
                Log.i((String)TAG, (String)"Could not set overlap anchor field in PopupWindow", (Throwable)e);
            }
        }
    }

    static boolean getOverlapAnchor(PopupWindow popupWindow) {
        if (sOverlapAnchorField != null) {
            try {
                return (Boolean)sOverlapAnchorField.get(popupWindow);
            }
            catch (IllegalAccessException e) {
                Log.i((String)TAG, (String)"Could not get overlap anchor field in PopupWindow", (Throwable)e);
            }
        }
        return false;
    }

    static {
        try {
            sOverlapAnchorField = PopupWindow.class.getDeclaredField("mOverlapAnchor");
            sOverlapAnchorField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Log.i((String)TAG, (String)"Could not fetch mOverlapAnchor field from PopupWindow", (Throwable)e);
        }
    }
}

