/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.util.StateSet;
import android.view.View;
import android.view.animation.Animation;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

final class StateListAnimator {
    private final ArrayList<Tuple> mTuples = new ArrayList();
    private Tuple mLastMatch = null;
    private Animation mRunningAnimation = null;
    private WeakReference<View> mViewRef;
    private Animation.AnimationListener mAnimationListener = new Animation.AnimationListener(){

        public void onAnimationEnd(Animation animation) {
            if (StateListAnimator.this.mRunningAnimation == animation) {
                StateListAnimator.this.mRunningAnimation = null;
            }
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    StateListAnimator() {
    }

    public void addState(int[] specs, Animation animation) {
        Tuple tuple = new Tuple(specs, animation);
        animation.setAnimationListener(this.mAnimationListener);
        this.mTuples.add(tuple);
    }

    Animation getRunningAnimation() {
        return this.mRunningAnimation;
    }

    View getTarget() {
        return this.mViewRef == null ? null : (View)this.mViewRef.get();
    }

    void setTarget(View view) {
        View current = this.getTarget();
        if (current == view) {
            return;
        }
        if (current != null) {
            this.clearTarget();
        }
        if (view != null) {
            this.mViewRef = new WeakReference<View>(view);
        }
    }

    private void clearTarget() {
        View view = this.getTarget();
        int size = this.mTuples.size();
        for (int i = 0; i < size; ++i) {
            Animation anim2 = this.mTuples.get((int)i).mAnimation;
            if (view.getAnimation() != anim2) continue;
            view.clearAnimation();
        }
        this.mViewRef = null;
        this.mLastMatch = null;
        this.mRunningAnimation = null;
    }

    void setState(int[] state) {
        Tuple match = null;
        int count = this.mTuples.size();
        for (int i = 0; i < count; ++i) {
            Tuple tuple = this.mTuples.get(i);
            if (!StateSet.stateSetMatches((int[])tuple.mSpecs, (int[])state)) continue;
            match = tuple;
            break;
        }
        if (match == this.mLastMatch) {
            return;
        }
        if (this.mLastMatch != null) {
            this.cancel();
        }
        this.mLastMatch = match;
        if (match != null) {
            this.start(match);
        }
    }

    private void start(Tuple match) {
        this.mRunningAnimation = match.mAnimation;
        View view = this.getTarget();
        if (view != null) {
            view.startAnimation(this.mRunningAnimation);
        }
    }

    private void cancel() {
        if (this.mRunningAnimation != null) {
            View view = this.getTarget();
            if (view != null && view.getAnimation() == this.mRunningAnimation) {
                view.clearAnimation();
            }
            this.mRunningAnimation = null;
        }
    }

    ArrayList<Tuple> getTuples() {
        return this.mTuples;
    }

    public void jumpToCurrentState() {
        View view;
        if (this.mRunningAnimation != null && (view = this.getTarget()) != null && view.getAnimation() == this.mRunningAnimation) {
            view.clearAnimation();
        }
    }

    static class Tuple {
        final int[] mSpecs;
        final Animation mAnimation;

        private Tuple(int[] specs, Animation Animation2) {
            this.mSpecs = specs;
            this.mAnimation = Animation2;
        }

        int[] getSpecs() {
            return this.mSpecs;
        }

        Animation getAnimation() {
            return this.mAnimation;
        }
    }
}

