DROP TABLE IF EXISTS Konta;
DROP TABLE IF EXISTS StatusBledu;
DROP TABLE IF EXISTS Bledy;
DROP TABLE IF EXISTS Komentarze;
DROP TABLE IF EXISTS ZrzutyEkranu;
DROP TABLE IF EXISTS Tagi;
DROP TABLE IF EXISTS Produkty;
DROP TABLE IF EXISTS BledyProdukty;

#START:create
CREATE TABLE Konta (
 id_konta SERIAL PRIMARY KEY,
 nazwa_konta VARCHAR(20),
 imie VARCHAR(20),
 nazwisko VARCHAR(20),
 email VARCHAR(20),
 skrot_hasla CHAR(64),
 zdjecie BLOB,
 stawka_godzinowa NUMERIC(9,2)
);

CREATE TABLE StatusBledu (
 status VARCHAR(20) PRIMARY KEY
);

CREATE TABLE Bledy (
 id_bledu SERIAL PRIMARY KEY,
 data_zgloszenia DATE NOT NULL,
 podsumowanie VARCHAR(80),
 opis VARCHAR(1000),
 rozwiazanie VARCHAR(1000),
 zgloszony_przez BIGINT UNSIGNED NOT NULL,
 przypisany_do BIGINT UNSIGNED,
 sprawdzony_przez BIGINT UNSIGNED,
 status VARCHAR(20) NOT NULL DEFAULT 'NOWY',
 priorytet VARCHAR(20),
 godziny NUMERIC(9,2),
 FOREIGN KEY (zgloszony_przez) REFERENCES Konta(id_konta),
 FOREIGN KEY (przypisany_do) REFERENCES Konta(id_konta),
 FOREIGN KEY (sprawdzony_przez) REFERENCES Konta(id_konta),
 FOREIGN KEY (status) REFERENCES StatusBledu(status)
);

CREATE TABLE Komentarze (
 id_komentarza SERIAL PRIMARY KEY,
 id_bledu BIGINT UNSIGNED NOT NULL,
 autor BIGINT UNSIGNED NOT NULL,
 data_komentarza DATETIME NOT NULL,
 komentarz TEXT NOT NULL,
 FOREIGN KEY (id_bledu) REFERENCES Bledy(id_bledu),
 FOREIGN KEY (autor) REFERENCES Konta(id_konta)
);

CREATE TABLE ZrzutyEkranu (
 id_bledu BIGINT UNSIGNED NOT NULL,
 id_obrazu BIGINT UNSIGNED NOT NULL,
 obraz_zrzut_ekranu BLOB,
 podpis VARCHAR(100),
 PRIMARY KEY (id_bledu, id_obrazu),
 FOREIGN KEY (id_bledu) REFERENCES Bledy(id_bledu)
);

CREATE TABLE Tagi (
 id_bledu BIGINT UNSIGNED NOT NULL,
 tag VARCHAR(20) NOT NULL,
 PRIMARY KEY (id_bledu, tag),
 FOREIGN KEY (id_bledu) REFERENCES Bledy(id_bledu)
);

CREATE TABLE Produkty (
 id_produktu SERIAL PRIMARY KEY,
 nazwa_produktu VARCHAR(50)
);

CREATE TABLE BledyProdukty (
 id_bledu BIGINT UNSIGNED NOT NULL,
 id_produktu BIGINT UNSIGNED NOT NULL,
 PRIMARY KEY (id_bledu, id_produktu),
 FOREIGN KEY (id_bledu) REFERENCES Bledy(id_bledu),
 FOREIGN KEY (id_produktu) REFERENCES Produkty(id_produktu)
);
#END:create

INSERT INTO Konta () VALUES ();

INSERT INTO Produkty (id_produktu, nazwa_produktu) VALUES
 (1, 'Open RoundFile'),
 (2, 'Visual TurboBuilder'),
 (3, 'ReConsider');

INSERT INTO Bledy (id_bledu, podsumowanie) VALUES
 (1234, 'awaria podczas zapisu'),
 (2345, 'zwikszy wydajno'),
 (3456, 'czarny ekran'),
 (5678, 'nieznany konflikt pomidzy produktami');

INSERT INTO BledyProdukty (id_bledu, id_produktu) VALUES
 (1234, 1),
 (1234, 3),
 (3456, 2),
 (5678, 1),
 (5678, 3);

INSERT INTO Komentarza (id_komentarza, id_bledu, komentarz) VALUES
 (6789, 1234, 'Awaria!'),
 (9876, 2345, 'wietny pomys!');

INSERT INTO Tagi () VALUES ();
