/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import android.text.TextUtils;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.ParameterLoader;

class ParameterLoaderImpl
implements ParameterLoader {
    private final Context ctx;

    public ParameterLoaderImpl(Context ctx) {
        if (ctx == null) {
            throw new NullPointerException("Context cannot be null");
        }
        this.ctx = ctx.getApplicationContext();
    }

    private int getResourceIdForType(String key, String type) {
        if (this.ctx == null) {
            return 0;
        }
        return this.ctx.getResources().getIdentifier(key, type, this.ctx.getPackageName());
    }

    @Override
    public String getString(String key) {
        int id = this.getResourceIdForType(key, "string");
        if (id == 0) {
            return null;
        }
        return this.ctx.getString(id);
    }

    @Override
    public boolean getBoolean(String key) {
        int id = this.getResourceIdForType(key, "bool");
        if (id == 0) {
            return false;
        }
        return "true".equalsIgnoreCase(this.ctx.getString(id));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        int id = this.getResourceIdForType(key, "integer");
        if (id == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(this.ctx.getString(id));
        }
        catch (NumberFormatException e) {
            Log.w("NumberFormatException parsing " + this.ctx.getString(id));
            return defaultValue;
        }
    }

    @Override
    public boolean isBooleanKeyPresent(String key) {
        return this.getResourceIdForType(key, "bool") != 0;
    }

    @Override
    public Double getDoubleFromString(String key) {
        String value = this.getString(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            Log.w("NumberFormatException parsing " + value);
            return null;
        }
    }
}

