/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import com.google.analytics.tracking.android.ExceptionParser;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.ServiceManager;
import com.google.analytics.tracking.android.Tracker;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler originalHandler;
    private final Tracker tracker;
    private final ServiceManager serviceManager;
    private ExceptionParser exceptionParser;

    public ExceptionReporter(Tracker tracker, ServiceManager serviceManager, Thread.UncaughtExceptionHandler originalHandler) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (serviceManager == null) {
            throw new NullPointerException("serviceManager cannot be null");
        }
        this.originalHandler = originalHandler;
        this.tracker = tracker;
        this.serviceManager = serviceManager;
        Log.iDebug("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.exceptionParser;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.exceptionParser = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String description = "";
        if (this.exceptionParser == null) {
            description = e.getMessage();
        } else {
            String threadName = t != null ? t.getName() : null;
            description = this.exceptionParser.getDescription(threadName, e);
        }
        Log.iDebug("Tracking Exception: " + description);
        this.tracker.trackException(description, true);
        this.serviceManager.dispatch();
        if (this.originalHandler != null) {
            Log.iDebug("Passing exception to original handler.");
            this.originalHandler.uncaughtException(t, e);
        }
    }
}

