/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import com.google.analytics.tracking.android.Log;
import java.util.HashMap;
import java.util.Map;

class MetaModel {
    private Map<String, MetaInfo> metaInfos = new HashMap<String, MetaInfo>();

    MetaModel() {
    }

    MetaInfo getMetaInfo(String key) {
        if (key.startsWith("&")) {
            return new MetaInfo(key.substring(1), null, null);
        }
        String tmpKey = key;
        if (key.contains("*")) {
            tmpKey = key.substring(0, key.indexOf("*"));
        }
        return this.metaInfos.get(tmpKey);
    }

    public void addField(String key, String urlParam, String defaultValue, Formatter formatter) {
        this.metaInfos.put(key, new MetaInfo(urlParam, defaultValue, formatter));
    }

    public static class MetaInfo {
        private final String urlParam;
        private final String defaultValue;
        private final Formatter formatter;

        public MetaInfo(String urlParam, String defaultValue, Formatter formatter) {
            this.urlParam = urlParam;
            this.defaultValue = defaultValue;
            this.formatter = formatter;
        }

        public String getUrlParam(String actualKey) {
            if (actualKey.contains("*")) {
                String param = this.urlParam;
                int slot = 0;
                String[] splits = actualKey.split("\\*");
                if (splits.length > 1) {
                    try {
                        slot = Integer.parseInt(splits[1]);
                    }
                    catch (NumberFormatException e) {
                        Log.w("Unable to parse slot for url parameter " + param);
                        return null;
                    }
                    return param + slot;
                }
                return null;
            }
            return this.urlParam;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Formatter getFormatter() {
            return this.formatter;
        }
    }

    public static interface Formatter {
        public String format(String var1);
    }
}

