/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import com.google.analytics.tracking.android.Hit;
import com.google.analytics.tracking.android.MetaModel;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

class HitBuilder {
    HitBuilder() {
    }

    public static Map<String, String> generateHitParams(MetaModel metaModel, Map<String, String> hit) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : hit.entrySet()) {
            String urlParam;
            MetaModel.MetaInfo metaInfo = metaModel.getMetaInfo(entry.getKey());
            if (metaInfo == null || (urlParam = metaInfo.getUrlParam(entry.getKey())) == null) continue;
            String value = entry.getValue();
            if (metaInfo.getFormatter() != null) {
                value = metaInfo.getFormatter().format(value);
            }
            if (value == null || value.equals(metaInfo.getDefaultValue())) continue;
            params.put(urlParam, value);
        }
        return params;
    }

    static String postProcessHit(Hit hit, long currentTimeMillis) {
        long queueTime;
        StringBuilder builder = new StringBuilder();
        builder.append(hit.getHitParams());
        if (hit.getHitTime() > 0L && (queueTime = currentTimeMillis - hit.getHitTime()) >= 0L) {
            builder.append("&").append("qt").append("=").append(queueTime);
        }
        builder.append("&").append("z").append("=").append(hit.getHitId());
        return builder.toString();
    }

    public static String encode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)("URL encoding failed for: " + input));
        }
    }
}

