#!/bin/bash -x

rm -rf /usr/local/src/{binutils*,build,bzip*,gcc*,zlib*}
# Sprawdzenie, czy udev nie blokuje sieci
if grep -q -i "release 6" /etc/redhat-release ; then
    rm -f /etc/udev/rules.d/70-persistent-net.rules
    mkdir /etc/udev/rules.d/70-persistent-net.rules
fi
rm -rf /dev/.udev/
if [ -f /etc/sysconfig/network-scripts/ifcfg-eth0 ] ; then
    sed -i "/^HWADDR/d" /etc/sysconfig/network-scripts/ifcfg-eth0
    sed -i "/^UUID/d" /etc/sysconfig/network-scripts/ifcfg-eth0
fi

# Usunięcie
yum remove -y audit aic94xx-firmware alsa-firmware alsa-tools-firmware ivtv-firmware  iwl100-firmware iwl105-firmware iwl135-firmware iwl2000-firmware iwl2030-firmware iwl3160-firmware iwl3945-firmware iwl4965-firmware iwl5000-firmware iwl5150-firmware iwl6000-firmware iwl6000g2a-firmware iwl6000g2b-firmware iwl6050-firmware iwl7260-firmware iwl7265-firmware libsysfs

# Aktualizacja pakietów
#yum update -y
yum clean all

# Ograniczenie użycia dysku
find /var/log/ -name "*.log" -exec rm -f {} \;
rm -f /var/log/anaconda.syslog
rm -f /var/log/dmesg.old
truncate -s0 /var/log/lastlog
truncate -s0 /var/log/wtmp
truncate -s0 /var/log/messages
truncate -s0 /var/log/lastlog


rm -rf /tmp/vola /tmp/*.gz /tmp/packer-provisioner-ansible-local

case "$PACKER_BUILDER_TYPE" in

  virtualbox-iso|virtualbox-ovf|vmware-iso|vmware-vmx|googlecompute)
      history -c
      # Wyzerowanie reszty wolnego miejsca za pomocą dd, a następnie usunięcie zapisanego pliku.
      dd if=/dev/zero of=/EMPTY bs=1M
      rm -f /EMPTY

      # OBEJŚCIE: usunięcie samego siebie: https://github.com/mitchellh/packer/issues/1536
      rm -f /tmp/script.sh
      
      # Dodanie `sync`, aby Packer nie zakończył pracy zbyt wcześnie, zanim duży plik zostanie usunięty.
      sync
      ;;
  *)
      echo "Koniec ${PACKER_BUILDER_TYPE}"
      ;;

esac
