# Rozdział 14

base_redis
=============

Rola ansible do zainstalowania Redis5 Sentinel na Centos/RHEL 7 (przy użyciu Satellite).

Wymagania
---------

Ta rola została opracowana do użytku lokalnego.

Zmienne roli
------------

Patrz defaults/main.yml

Zależności
----------

W swojej ewidencji zdefiniuj hosty, takie jak:

```
[redis_master]
node0.example.com

[redis_slave]
node1.example.com
node2.example.com

[redis_sentinel]
node0.example.com
node1.example.com
node2.example.com

```
Przykładowy scenariusz
----------------------

```
---
# Instalacja Redis Sentinel na 3 maszynach wirtualnych RHEL7

- name: Wykrycie głównego węzła Redis
  hosts: redis_server
  become: true
  roles:
    - {role: base_redis, tags: master, slave}

- name: Instalacja głównego węzła Redis
  hosts: redis_leader
  become: true
  vars:
    redis_server: true
  roles:
    - {role: base_redis, tags: master}

- name: Instalacja podrzędnych wezłów Redis
  hosts: redis_server
  become: true
  vars:
    redis_server: true
  roles:
    - {role: base_redis, tags: slave}

- name: Konfiguracja wezłów Redis
  hosts: redis_sentinel
  become: true
  vars:
    redis_sentinel: true
    redis_sentinel_monitors:
      - name: mymaster
        # host: "{{ groups.redis_master[0] }}"
        host: "{{ master_hostname }}"
        port: "{{ redis_host }}"
        quorum: "{{ groups.redis_server|length -1 }}"
  roles:
    - {role: base_redis, tags: sentinel}
```


Licencja
--------

MIT

Informacja o autorze
--------------------
@bbaassssiiee
