#!/usr/bin/env python3
""" Skrypt definiujący poświadczenia administratora. """
# Wykorzystuje trzy zmienne środowiskowe.
# PROJECT_DIR: główny katalog projektu
# PROJECT_APP: nazwa aplikacji
# ADMIN_PASSWORD: hasło administratora

import os
import sys

# Dopisanie katalogu projektu do zmiennej PATH.
proj_dir = os.path.expanduser(os.environ['PROJECT_DIR'])
sys.path.append(proj_dir)

proj_app = os.environ['PROJECT_APP']
os.environ['DJANGO_SETTINGS_MODULE'] = proj_app + '.settings'
import django
django.setup()
from django.contrib.auth import get_user_model
User = get_user_model()
u, _ = User.objects.get_or_create(username='admin')
u.is_staff = u.is_superuser = True
u.set_password(os.environ['ADMIN_PASSWORD'])
u.save()
