#!/usr/bin/env python3
""" Skrypt definiujący domenę strony. """
# Wykorzystuje trzy zmienne środowiskowe.
# PROJECT_DIR: główny katalog projektu
# PROJECT_APP: nazwa aplikacji
# WEBSITE_DOMAIN: domena strony (na przykład www.aplikacja.pl)

import os
import sys

# Dopisanie katalogu projektu do zmiennej PATH.
proj_dir = os.path.expanduser(os.environ['PROJECT_DIR'])
sys.path.append(proj_dir)

proj_app = os.environ['PROJECT_APP']
os.environ['DJANGO_SETTINGS_MODULE'] = proj_app + '.settings'
import django
django.setup()
from django.conf import settings
from django.contrib.sites.models import Site
domain = os.environ['WEBSITE_DOMAIN']
Site.objects.filter(id=settings.SITE_ID).update(domain=domain)
Site.objects.get_or_create(domain=domain)
