#!/bin/bash -e
# WANT_JSON
# Odczytanie zmiennych z pliku.
host=$(jq -r .host <"$1")
port=$(jq -r .port <"$1")
timeout=$(jq -r .timeout <"$1")

# Domyślnie timeout=3.
if [[ $timeout = null ]]; then
    timeout=3
fi
# Sprawdzenie, czy serwer jest dostępny.
if nc -z -w "$timeout" "$host" "$port"; then
    echo '{"changed": false}'
else
    echo "{\"failed\": true, \"msg\": \"Serwer $host:$port niedostępny\"}"
fi
