// # Konfiguracja Ghost
// Instalacja Ghost w róznych środowiskach [environments](http://support.ghost.org/config/#about-environments).

// Ghost domyślnie działa w trybie deweloperskim. Pełną dokumentację można znaleźć pod adresem http://support.ghost.org/config/

var path = require('path'),
    config;

config = {
    // ### Środowisko produkcyjne
    // Uruchamiając Ghost użyj środowiska produkcyjnego.
    // Tutaj skonfiguruj adres URL i ustawienia poczty.
    production: {
        url: 'http://localhost:8000',
        mail: {},
        database: {
            client: 'sqlite3',
            connection: {
                filename: path.join(process.env.GHOST_CONTENT, '/data/ghost.db')
            },
            debug: false
        },

        server: {
            host: '0.0.0.0',
            port: '2368'
        }
    },

    // ### Środowisko deweloperskie **(domyślne)**
    development: {
        // Adres URL używany podczas udostępniania linków do witryny, np. w RSS i e-mailu.
        // Zmień to na opublikowany adres URL swojego bloga Ghost.
        url: 'http://localhost:8000',

        // Przykładowa polityka odsyłaczy
        // Instrukcje na stronie https://www.w3.org/TR/referrer-policy/
        // default 'origin-when-cross-origin',
        // referrerPolicy: 'origin-when-cross-origin',

        // Przykładowa konfiguracja poczty
        // Instrukcje na stronie http://support.ghost.org/mail
        // ```
        //  mail: {
        //      transport: 'SMTP',
        //      options: {
        //          service: 'Mailgun',
        //          auth: {
        //              user: '', // mailgun username
        //              pass: ''  // mailgun password
        //          }
        //      }
        //  },
        // ```

        // #### Baza danych
        // Ghost obsługuje SQLite3 (domyślnie), MySQL i PostgreSQL
        database: {
            client: 'sqlite3',
            connection: {
                filename: path.join(process.env.GHOST_CONTENT, '/data/ghost-dev.db')
            },
            debug: false
        },
        // #### Serwer
        // Może być adres i port (domyślnie), lub gniazdo
        server: {
            // Adres przekazywany do procedury `net.Server#listen()` węzła
            host: '0.0.0.0',
            // Port przekazywany do procedury `net.Server#listen()` węzła, dla węzła iisnode ustaw `process.env.PORT`
            port: '2368'
        },
        // #### Ścieżki
        // Określ, gdzie znajduje się katalog treści
        paths: {
            contentPath: path.join(process.env.GHOST_CONTENT, '/')
        }
    },

    // **Poniższe ustawienia są tylko dla programistów**

    // ### Testy
    // Używane podczas opracowywania aplikacji, przeprowadzania testów i sprawdzania kondycji Ghosta
    // Użyty innynumeru portu
    testing: {
        url: 'http://0.0.0.0:2369',
        database: {
            client: 'sqlite3',
            connection: {
                filename: path.join(process.env.GHOST_CONTENT, '/data/ghost-test.db')
            },
            pool: {
                afterCreate: function (conn, done) {
                    conn.run('PRAGMA synchronous=OFF;' +
                    'PRAGMA journal_mode=MEMORY;' +
                    'PRAGMA locking_mode=EXCLUSIVE;' +
                    'BEGIN EXCLUSIVE; COMMIT;', done);
                }
            },
            useNullAsDefault: true
        },
        server: {
            host: '0.0.0.0',
            port: '2369'
        },
        logging: false
    },

    // ### Testy MySQL
    // Używany przez Travis — automatyczne testy przeprowadzane przez GitHub
    'testing-mysql': {
        url: 'http://0.0.0.0:2369',
        database: {
            client: 'mysql',
            connection: {
                host     : '0.0.0.0',
                user     : 'root',
                password : '',
                database : 'ghost_testing',
                charset  : 'utf8'
            }
        },
        server: {
            host: '0.0.0.0',
            port: '2369'
        },
        logging: false
    },

    // ### Testy PostgreSQL
    // Używany przez Travis — automatyczne testy przeprowadzane przez GitHub
    'testing-pg': {
        url: 'http://0.0.0.0:2369',
        database: {
            client: 'pg',
            connection: {
                host     : '0.0.0.0',
                user     : 'postgres',
                password : '',
                database : 'ghost_testing',
                charset  : 'utf8'
            }
        },
        server: {
            host: '0.0.0.0',
            port: '2369'
        },
        logging: false
    }
};

module.exports = config;
