# Rozdział 16

## ZMIENNE ŚRODOWISKOWE

# Konfiguracja chmury Azure

- Konfiguracja uwierzytelnienia [https://packer.io/docs/builders/azure#authentication-for-azure](https://packer.io/docs/builders/azure#authentication-for-azure)

- Utworzenie grupy zasobów w pobliskiej lokalizacji ARM_LOCATION

```sh
az group create -l "${ARM_LOCATION}" -n "${ARM_RESOURCE_GROUP}"
```

- Utworzenie konta ARM_STORAGE_ACCOUNT w tej samej lokalizacji ARM_LOCATION

```sh
az storage account create -n "$ARM_STORAGE_ACCOUNT" \
  -g $ARM_RESOURCE_GROUP -l $ARM_LOCATION --sku Premium_LRS --https-only true
```

- Eksport zmiennych środowiskowych

```
export ARM_RESOURCE_GROUP=
export ARM_STORAGE_ACCOUNT=
export ARM_LOCATION=
export ARM_SUBSCRIPTION_ID=
```

# Konfiguracja chmury Google:
- Utwórz projekt w [https://console.cloud.google.com/](https://console.cloud.google.com/)
- Skopiuj Project ID
- Skonfiguruj uwierzytelnienie API
[https://cloud.google.com/sdk/gcloud/reference/auth/application-default](https://cloud.google.com/sdk/gcloud/reference/auth/application-default)
```
gcloud auth application-default login
```

```
export GCP_PROJECT_ID=
export CLOUDSDK_COMPUTE_REGION=europe-west4
export CLOUDSDK_COMPUTE_ZONE=europe-west4-a
```

# Konfiguracja Tailscale
- Klucze dla Tailscale
  [https://login.tailscale.com/admin/settings/authkeys](https://login.tailscale.com/admin/settings/authkeys)
```
export TAILSCALE_AUTHKEY=""
```
