# Rozdział 19

goss
----

Rola ansible do pobrania pliku binarnego **goss** do katalogu {{goss_path}}.
Tag `validate` uruchamia kontrolę stanu. Analizuje pliki `{{ goss_test_directory }}/test_*.yml`
utworzone przez inne role.

Służą one do sprawdzania zgodnoścci serwera/kontenera ze specyfikacją.

[goss rocks](https://github.com/aelsabbahy/goss#goss---quick-and-easy-server-validation)

Wymagania
---------

System Linux. Maszyna z uruchomionym Ansible musi mieć zainstalowane `python-jmespath`.

Zmienne roli
--------------

    goss_version: "v0.3.10"
    goss_path: "/usr/bin/"
    goss_arch: amd64
    goss_dest: /usr/bin/goss
    goss_url: "https://github.com/aelsabbahy/goss/releases/download/{{ goss_version }}/goss-linux-{{ goss_arch }}"
    goss_test_directory: /etc/goss.d
    goss_test_directory_mode: 0700
    goss_user: root
    goss_download: localhost  # Może być też 'direct'

Wszelkie nowe wersje `goss_version` muszą być ręcznie wklejone do `vars/main.yml`
z powodu sprawdzania sumy kontrolnej. Obecnie obsługiwane są wszystkie znane wersje.

Zależności
----------

Brak

Przykładowy scenariusz
----------------------

    - hosts: servers
      roles:
         - dockpack.base_goss

Licencja
--------

MIT

Informacja o autorze
--------------------
bbaassssiiee często używa Ansible, w tej roli instaluje goss do testowania integracji.
Ta rola jest oparta na roli Seana Abota: https://github.com/sean-abbott/ansible-role-install_goss.