#!/bin/bash -x

rm -rf /dev/.udev/
if [ -f /etc/sysconfig/network-scripts/ifcfg-eth0 ] ; then
    sed -i "/^HWADDR/d" /etc/sysconfig/network-scripts/ifcfg-eth0
    sed -i "/^UUID/d" /etc/sysconfig/network-scripts/ifcfg-eth0
fi

# Aktualizacja pakietów
#yum update -y
yum clean all

# Ograniczenie użycia dysku
find /var/log/ -name "./*.log" -exec rm -f {} \;
rm -f /var/log/anaconda.syslog
rm -f /var/log/dmesg.old
truncate -s0 /var/log/lastlog
truncate -s0 /var/log/wtmp
truncate -s0 /var/log/messages
truncate -s0 /var/log/lastlog


rm -rf /tmp/vola /tmp/*.gz /tmp/packer-provisioner-ansible-local

case "$PACKER_BUILDER_TYPE" in

  virtualbox-iso)
      # shellcheck disable=SC2155
      readonly swapuuid=$(/sbin/blkid -o value -l -s UUID -t TYPE=swap)
      # shellcheck disable=SC2155
      readonly swappart=$(readlink -f /dev/disk/by-uuid/"$swapuuid")
      /sbin/swapoff "$swappart"
      dd if=/dev/zero of="$swappart" bs=1M || echo "dd exit code $? is suppressed"
      /sbin/mkswap -U "$swapuuid" "$swappart"
      history -c
      # Wyzerowanie reszty wolnego miejsca za pomocą dd, a następnie usunięcie zapisanego pliku.
      dd if=/dev/zero of=/EMPTY bs=1M
      rm -f /EMPTY

      # OBEJŚCIE: usunięcie samego siebie: https://github.com/mitchellh/packer/issues/1536
      rm -f /tmp/script.sh

      # Dodanie `sync`, aby Packer nie zakończył pracy zbyt wcześnie, zanim duży plik zostanie usunięty.
      sync
      ;;
  *)
      echo "Koniec ${PACKER_BUILDER_TYPE}"
      ;;

esac
